/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Biome;
import forge.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import forge.com.gitlab.cdagaming.craftpresence.config.element.PresenceData;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.PresenceSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import net.minecraft.client.gui.GuiScreen;

public class BiomeSettingsGui
extends ConfigurationGui<Biome> {
    private final Biome INSTANCE;
    private final Biome DEFAULTS = this.getCurrentData().getDefaults();
    private final ModuleData defaultData;
    private ExtendedButtonControl biomeMessagesButton;
    private ExtendedTextControl defaultMessage;

    BiomeSettingsGui(GuiScreen parentScreen) {
        super(parentScreen, "gui.config.title", "gui.config.title.biome_messages");
        this.INSTANCE = this.getCurrentData().copy();
        this.defaultData = this.getCurrentData().biomeData.get("default");
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        String defaultBiomeMessage = Config.getProperty(this.defaultData, "textOverride") != null ? this.defaultData.getTextOverride() : "";
        this.defaultMessage = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, "gui.config.message.default.biome", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", CraftPresence.CLIENT.generateArgumentMessage("biome."))))));
        this.defaultMessage.setControlMessage(defaultBiomeMessage);
        this.biomeMessagesButton = this.childFrame.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(1), 180, 20, "gui.config.name.biome_messages.biome_messages", () -> this.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.biome", new Object[0]), CraftPresence.BIOMES.BIOME_NAMES, null, null, true, true, ScrollableListControl.RenderType.None, (attributeName, currentValue) -> {
            ModuleData defaultBiomeData = this.getCurrentData().biomeData.get("default");
            ModuleData currentBiomeData = this.getCurrentData().biomeData.get(attributeName);
            String defaultMessage = Config.getProperty(defaultBiomeData, "textOverride") != null ? defaultBiomeData.getTextOverride() : "";
            String currentMessage = Config.getProperty(currentBiomeData, "textOverride") != null ? currentBiomeData.getTextOverride() : "";
            CraftPresence.CONFIG.hasChanged = true;
            ModuleData newData = new ModuleData();
            if (StringUtils.isNullOrEmpty(currentMessage) || currentMessage.equals(defaultMessage)) {
                newData.setTextOverride(defaultMessage);
            }
            newData.setIconOverride((String)currentValue);
            this.getCurrentData().biomeData.put((String)attributeName, newData);
        }, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getCurrentData().biomeData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getCurrentData().biomeData.get("default");
            screenInstance.currentData = this.getCurrentData().biomeData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.biome.edit_specific_biome", attributeName);
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, (screenInstance, attributeName, inputText) -> {
            screenInstance.currentData.setTextOverride((String)inputText);
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().biomeData.put((String)attributeName, screenInstance.currentData);
            if (!CraftPresence.BIOMES.BIOME_NAMES.contains(attributeName)) {
                CraftPresence.BIOMES.BIOME_NAMES.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().biomeData.remove(attributeName);
            if (!CraftPresence.BIOMES.DEFAULT_NAMES.contains(attributeName)) {
                CraftPresence.BIOMES.BIOME_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance, isPresenceButton) -> {
            if (isPresenceButton.booleanValue()) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                this.openScreen(new PresenceSettingsGui((GuiScreen)screenInstance, currentPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                String defaultIcon = Config.getProperty(screenInstance.defaultData, "iconOverride") != null ? screenInstance.defaultData.getIconOverride() : this.getCurrentData().fallbackBiomeIcon;
                String specificIcon = Config.getProperty(screenInstance.currentData, "iconOverride") != null ? screenInstance.currentData.getIconOverride() : defaultIcon;
                this.openScreen(new SelectorGui((GuiScreen)screenInstance, ModUtils.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), specificIcon, (String)attributeName, true, false, ScrollableListControl.RenderType.DiscordAsset, (innerAttributeName, innerCurrentValue) -> screenInstance.currentData.setIconOverride((String)innerCurrentValue), null));
            }
        }, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", CraftPresence.CLIENT.generateArgumentMessage("biome.")))))))), () -> {
            if (!this.biomeMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_biome_data", new Object[0]))));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", CraftPresence.CLIENT.generateArgumentMessage("biome."))));
            }
        }, new String[0]));
        this.childFrame.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(2), 180, 20, "gui.config.name.biome_messages.biome_icon", () -> this.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), this.getCurrentData().fallbackBiomeIcon, null, true, false, ScrollableListControl.RenderType.DiscordAsset, (attributeName, currentValue) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().fallbackBiomeIcon = currentValue;
        }, null)), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_icon", new Object[0]))), new String[0]));
        this.proceedButton.setOnHover(() -> {
            if (!this.proceedButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
            }
        });
    }

    @Override
    protected boolean canReset() {
        return !this.getCurrentData().equals(this.DEFAULTS);
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected boolean resetData() {
        return this.setCurrentData(this.DEFAULTS);
    }

    @Override
    protected boolean canSync() {
        return true;
    }

    @Override
    protected boolean allowedToSync() {
        return true;
    }

    @Override
    protected boolean syncData() {
        return this.setCurrentData(Config.loadOrCreate().biomeSettings);
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.defaultMessage.getControlMessage()));
        this.biomeMessagesButton.setControlEnabled(CraftPresence.BIOMES.enabled);
    }

    @Override
    protected void applySettings() {
        String defaultBiomeMessage;
        String string = defaultBiomeMessage = Config.getProperty(this.defaultData, "textOverride") != null ? this.defaultData.getTextOverride() : "";
        if (!this.defaultMessage.getControlMessage().equals(defaultBiomeMessage)) {
            CraftPresence.CONFIG.hasChanged = true;
            ModuleData defaultBiomeData = this.getCurrentData().biomeData.getOrDefault("default", new ModuleData());
            defaultBiomeData.setTextOverride(this.defaultMessage.getControlMessage());
            this.getCurrentData().biomeData.put("default", defaultBiomeData);
        }
    }

    @Override
    protected Biome getOriginalData() {
        return this.INSTANCE;
    }

    @Override
    protected Biome getCurrentData() {
        return CraftPresence.CONFIG.biomeSettings;
    }

    @Override
    protected boolean setCurrentData(Biome data) {
        if (!this.getCurrentData().equals(data)) {
            this.getCurrentData().transferFrom(data);
            CraftPresence.CONFIG.hasChanged = true;
            return true;
        }
        return false;
    }
}

