/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils;

import external.com.jagrosh.discordipc.entities.DiscordBuild;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import forge.com.gitlab.cdagaming.craftpresence.impl.Module;
import forge.com.gitlab.cdagaming.craftpresence.impl.TreeMapBuilder;
import forge.com.gitlab.cdagaming.craftpresence.integrations.pack.Pack;
import forge.com.gitlab.cdagaming.craftpresence.integrations.pack.atlauncher.ATLauncherUtils;
import forge.com.gitlab.cdagaming.craftpresence.integrations.pack.curse.CurseUtils;
import forge.com.gitlab.cdagaming.craftpresence.integrations.pack.mcupdater.MCUpdaterUtils;
import forge.com.gitlab.cdagaming.craftpresence.integrations.pack.multimc.MultiMCUtils;
import forge.com.gitlab.cdagaming.craftpresence.integrations.pack.technic.TechnicUtils;
import forge.com.gitlab.cdagaming.craftpresence.integrations.replaymod.ReplayModUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.world.BiomeUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public class CommandUtils {
    private static final ThreadFactory threadFactory = r -> {
        Thread t = new Thread(r, "CraftPresence");
        t.setDaemon(true);
        return t;
    };
    private static final ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor(threadFactory);
    private static final Map<String, Module> modules = new TreeMapBuilder<String, BiomeUtils>().put("_biome", CraftPresence.BIOMES).put("_dimension", (BiomeUtils)((Object)CraftPresence.DIMENSIONS)).put("_item", (BiomeUtils)((Object)CraftPresence.TILE_ENTITIES)).put("_entity", (BiomeUtils)((Object)CraftPresence.ENTITIES)).put("_server", (BiomeUtils)((Object)CraftPresence.SERVER)).put("_screen", (BiomeUtils)((Object)CraftPresence.GUIS)).build();
    private static final Map<String, Pack> packModules = new TreeMapBuilder<String, ATLauncherUtils>().put("atlauncher", new ATLauncherUtils()).put("curse", (ATLauncherUtils)((Object)new CurseUtils())).put("multimc", (ATLauncherUtils)((Object)new MultiMCUtils())).put("mcupdater", (ATLauncherUtils)((Object)new MCUpdaterUtils())).put("technic", (ATLauncherUtils)((Object)new TechnicUtils())).build();
    private static MenuStatus status = MenuStatus.None;

    public static MenuStatus getMenuState() {
        return status;
    }

    public static void setMenuState(MenuStatus newState) {
        MenuStatus oldState = status;
        status = newState;
        if (oldState != newState) {
            CommandUtils.updateMenuPresence();
        }
    }

    public static void clearMenuState() {
        CommandUtils.setMenuState(MenuStatus.None);
    }

    public static void updateMenuPresence() {
        switch (status) {
            case Loading: {
                CommandUtils.syncMenuData(CraftPresence.CONFIG.statusMessages.loadingData);
                break;
            }
            case MainMenu: {
                CommandUtils.syncMenuData(CraftPresence.CONFIG.statusMessages.mainMenuData);
                break;
            }
            default: {
                CommandUtils.clearMenuPresence();
            }
        }
    }

    public static ScheduledExecutorService getThreadPool() {
        return exec;
    }

    public static ThreadFactory getThreadFactory() {
        return threadFactory;
    }

    public static boolean isDebugMode() {
        return ModUtils.IS_DEV_FLAG || CommandUtils.isVerboseMode() || CraftPresence.CONFIG != null && CraftPresence.CONFIG.advancedSettings.debugMode;
    }

    public static boolean isVerboseMode() {
        return ModUtils.IS_VERBOSE_FLAG || CraftPresence.CONFIG != null && CraftPresence.CONFIG.advancedSettings.verboseMode;
    }

    public static void syncModuleArguments() {
        for (Map.Entry<String, Module> module : modules.entrySet()) {
            String name = module.getKey();
            name = (name.startsWith("_") ? "" : "_") + name;
            CraftPresence.CLIENT.syncArgument(name + ".instance", module.getValue());
        }
    }

    public static void syncPackArguments() {
        boolean foundPack = false;
        for (Map.Entry<String, Pack> pack : packModules.entrySet()) {
            Pack data = pack.getValue();
            if (!data.hasPackType()) {
                data.setPackType(pack.getKey());
            }
            if (!data.hasPackName()) continue;
            CraftPresence.CLIENT.syncArgument("pack.type", data.getPackType());
            CraftPresence.CLIENT.syncArgument("pack.name", data.getPackName());
            CraftPresence.CLIENT.syncArgument("pack.icon", CraftPresence.CLIENT.imageOf("pack.icon", true, data.getPackIcon()));
            foundPack = true;
            break;
        }
        if (!foundPack) {
            CraftPresence.CLIENT.removeArguments("pack");
        }
    }

    public static void clearModuleData() {
        for (Module module : modules.values()) {
            module.clearClientData();
        }
        CommandUtils.clearMenuState();
    }

    public static void addModule(String moduleId, Module instance) {
        modules.put(moduleId, instance);
    }

    public static void addModule(String moduleId, Pack instance) {
        packModules.put(moduleId, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadData(boolean forceUpdateRPC) {
        ModUtils.TRANSLATOR.onTick();
        CraftPresence.SYSTEM.onTick();
        CraftPresence.instance.func_152344_a(CraftPresence.KEYBINDINGS::onTick);
        CraftPresence.SYSTEM.TICK_LOCK.lock();
        try {
            if (CraftPresence.CLIENT.isAvailable()) {
                for (Module module : modules.values()) {
                    if (!module.canBeLoaded()) continue;
                    module.onTick();
                    if (!forceUpdateRPC || !module.isInUse()) continue;
                    module.updatePresence();
                }
                if (forceUpdateRPC) {
                    CommandUtils.updateMenuPresence();
                }
                CraftPresence.CLIENT.onTick();
            }
        }
        catch (Throwable ex) {
            List<String> splitEx = StringUtils.splitTextByNewLine(StringUtils.getStackTrace(ex));
            String messagePrefix = ModUtils.TRANSLATOR.translate("gui.config.message.editor.message", new Object[0]);
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.module", new Object[0]), new Object[0]);
            if (CommandUtils.isVerboseMode()) {
                ModUtils.LOG.error(messagePrefix, new Object[0]);
                ex.printStackTrace();
            } else {
                ModUtils.LOG.error("%1$s \"%2$s\"", messagePrefix, splitEx.get(0));
                if (splitEx.size() > 1) {
                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.verbose", new Object[0]), new Object[0]);
                }
            }
            CraftPresence.CLIENT.shutDown(false);
        }
        finally {
            CraftPresence.SYSTEM.TICK_LOCK.unlock();
            CraftPresence.SYSTEM.postTick();
        }
    }

    public static void rebootRPC(boolean flushOverride) {
        DiscordBuild preferredBuild;
        String clientId = CraftPresence.CONFIG.generalSettings.clientId;
        flushOverride = flushOverride || !CraftPresence.CLIENT.CLIENT_ID.equals(clientId);
        CraftPresence.CLIENT.shutDown();
        if (flushOverride) {
            DiscordAssetUtils.emptyData();
            CraftPresence.CLIENT.CLIENT_ID = clientId;
        }
        if (!CraftPresence.CLIENT.PREFERRED_CLIENT.equals((Object)(preferredBuild = DiscordBuild.from(CraftPresence.CONFIG.generalSettings.preferredClientLevel)))) {
            CraftPresence.CLIENT.PREFERRED_CLIENT = preferredBuild;
        }
        DiscordAssetUtils.loadAssets(clientId, true);
        CraftPresence.CLIENT.init(CraftPresence.CONFIG.generalSettings.resetTimeOnInit);
    }

    public static void rebootRPC() {
        CommandUtils.rebootRPC(false);
    }

    public static void init() {
        for (Map.Entry<String, Pack> pack : packModules.entrySet()) {
            String type = pack.getKey();
            Pack data = pack.getValue();
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.pack.init", type), new Object[0]);
            if (data.load()) {
                ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.pack.loaded", type, data.getPackName(), data.getPackIcon()), new Object[0]);
                break;
            }
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.pack", type), new Object[0]);
        }
        DiscordAssetUtils.loadAssets(CraftPresence.CONFIG.generalSettings.clientId, true);
        CraftPresence.KEYBINDINGS.register();
        if (FileUtils.findValidClass("com.replaymod.core.ReplayMod") != null) {
            CommandUtils.addModule("integration.replaymod", new ReplayModUtils());
        }
    }

    public static void syncMenuData(ModuleData currentData) {
        String currentMessage = Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : "";
        String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : CraftPresence.CONFIG.generalSettings.defaultIcon;
        String formattedIcon = CraftPresence.CLIENT.imageOf("menu.icon", true, currentIcon);
        CraftPresence.CLIENT.clearPartyData(true, false);
        CraftPresence.CLIENT.syncOverride(currentData, "menu.message", "menu.icon");
        CraftPresence.CLIENT.syncArgument("menu.message", currentMessage);
        CraftPresence.CLIENT.syncArgument("menu.icon", formattedIcon);
    }

    public static void clearMenuPresence() {
        CraftPresence.CLIENT.clearOverride("menu.message", "menu.icon");
        CraftPresence.CLIENT.removeArguments("menu");
    }

    public static enum MenuStatus {
        MainMenu,
        Loading,
        None;

    }
}

