/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils;

import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    public static String toString(Instant date, String toFormat, String toTimeZone) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(toFormat);
        if (date != null && !StringUtils.isNullOrEmpty(toTimeZone)) {
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(date, ZoneId.of("UTC")).withZoneSameInstant(ZoneId.of(toTimeZone));
            return formatter.format(zonedDateTime);
        }
        return date != null ? formatter.format(date.atZone(ZoneOffset.UTC)) : "";
    }

    public static String toString(Instant date, String toFormat) {
        return TimeUtils.toString(date, toFormat, null);
    }

    public static Instant toInstance(String dateString, String fromFormat, String fromTimeZone) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(fromFormat);
            if (!StringUtils.isNullOrEmpty(fromTimeZone)) {
                formatter = formatter.withZone(ZoneId.of(fromTimeZone));
            }
            return formatter.parse((CharSequence)dateString, Instant::from);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Instant toInstance(String dateString, String fromFormat) {
        return TimeUtils.toInstance(dateString, fromFormat, null);
    }

    public static String convertTime(String dateString, String fromFormat, String fromTimeZone, String toFormat, String toTimeZone) {
        return TimeUtils.toString(TimeUtils.toInstance(dateString, fromFormat, fromTimeZone), toFormat, toTimeZone);
    }

    public static String convertFormat(String dateString, String fromFormat, String toFormat) {
        return TimeUtils.convertTime(dateString, fromFormat, null, toFormat, null);
    }

    public static String convertZone(String dateString, String fromFormat, String fromTimeZone, String toTimeZone) {
        return TimeUtils.convertTime(dateString, fromFormat, fromTimeZone, fromFormat, toTimeZone);
    }

    public static Pair<Long, Instant> fromWorldTime(long worldTime, long tickOffset, long ticksPerDay, long ticksPerHour, long ticksPerMinute) {
        long days = worldTime / ticksPerDay;
        long dayTicks = worldTime % ticksPerDay;
        if ((dayTicks += tickOffset) > ticksPerDay) {
            dayTicks -= ticksPerDay;
        }
        long hourTicks = dayTicks % ticksPerHour;
        long minuteTicks = hourTicks % ticksPerMinute;
        long hours = dayTicks / ticksPerHour;
        long minutes = hourTicks / ticksPerMinute;
        long seconds = minuteTicks * (60L / ticksPerMinute);
        long millis = ((hours * 60L + minutes) * 60L + seconds) * 1000L;
        return new Pair<Long, Instant>(days, Instant.ofEpochMilli(millis));
    }

    public static Pair<Long, Instant> fromWorldTime(long worldTime, long ticksPerDay, long ticksPerHour, long ticksPerMinute) {
        return TimeUtils.fromWorldTime(worldTime, 0L, ticksPerDay, ticksPerHour, ticksPerMinute);
    }

    public static Pair<Long, Instant> fromWorldTime(long worldTime) {
        return TimeUtils.fromWorldTime(worldTime, 6000L, 24000L, 1000L, 16L);
    }

    public static String epochToString(long epochTime, String format, String timeZone) {
        return TimeUtils.toString(TimeUtils.fromEpoch(epochTime), format, timeZone);
    }

    public static String epochToString(long epochTime, String format) {
        return TimeUtils.epochToString(epochTime, format, null);
    }

    public static long stringToEpoch(String dateString, String format, String timeZone) {
        return TimeUtils.toEpoch(TimeUtils.toInstance(dateString, format, timeZone));
    }

    public static long stringToEpoch(String dateString, String format) {
        return TimeUtils.stringToEpoch(dateString, format, null);
    }

    public static Instant fromEpoch(long epochTime) {
        return Instant.ofEpochSecond(epochTime);
    }

    public static long toEpoch(Instant data) {
        return data != null ? data.getEpochSecond() : 0L;
    }

    public static Instant getCurrentTime() {
        return Instant.now();
    }

    public static Duration getDuration(Temporal start, Temporal end) {
        return Duration.between(start, end);
    }

    public static Duration getDurationFrom(Temporal start) {
        return TimeUtils.getDuration(start, TimeUtils.getCurrentTime());
    }

    public static Duration getDurationTo(Temporal end) {
        return TimeUtils.getDuration(TimeUtils.getCurrentTime(), end);
    }

    public static TemporalUnit getChronoUnitFrom(String name) {
        return ChronoUnit.valueOf(name.toUpperCase());
    }

    public static TimeUnit getTimeUnitFrom(String name) {
        return TimeUnit.valueOf(name.toUpperCase());
    }

    public static Temporal appendTime(Temporal temporal, long amount, TemporalUnit unit) {
        return temporal.plus(amount, unit);
    }

    public static Temporal appendTime(Temporal temporal, long amount, String unit) {
        return TimeUtils.appendTime(temporal, amount, TimeUtils.getChronoUnitFrom(unit));
    }
}

