/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.world;

import external.io.github.classgraph.ClassInfo;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import forge.com.gitlab.cdagaming.craftpresence.impl.Module;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.MappingUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.util.List;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeUtils
implements Module {
    private final List<BiomeGenBase> BIOME_TYPES = StringUtils.newArrayList();
    public boolean enabled = false;
    public List<String> BIOME_NAMES = StringUtils.newArrayList();
    public List<String> DEFAULT_NAMES = StringUtils.newArrayList();
    private boolean isInUse = false;
    private boolean hasScanned = false;
    private String CURRENT_BIOME_NAME;
    private String CURRENT_BIOME_IDENTIFIER;
    private BiomeGenBase CURRENT_BIOME;

    @Override
    public void emptyData() {
        this.hasScanned = false;
        this.DEFAULT_NAMES.clear();
        this.BIOME_NAMES.clear();
        this.BIOME_TYPES.clear();
        this.clearClientData();
    }

    @Override
    public void clearClientData() {
        this.CURRENT_BIOME = null;
        this.CURRENT_BIOME_NAME = null;
        this.CURRENT_BIOME_IDENTIFIER = null;
        this.setInUse(false);
        CraftPresence.CLIENT.removeArguments("biome", "data.biome");
        CraftPresence.CLIENT.clearOverride("biome.message", "biome.icon");
    }

    @Override
    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.generalSettings.detectBiomeData : this.enabled;
        boolean bl = needsUpdate = this.enabled && !this.hasScanned && this.canFetchData();
        if (needsUpdate) {
            this.scanForData();
            this.hasScanned = true;
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearClientData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
    }

    @Override
    public void updateData() {
        BiomeGenBase newBiome = CraftPresence.player.field_70170_p.func_72807_a((int)CraftPresence.player.field_70165_t, (int)CraftPresence.player.field_70161_v);
        String newBiomeName = StringUtils.formatIdentifier(newBiome.field_76791_y, false, !CraftPresence.CONFIG.advancedSettings.formatWords);
        String newBiome_primaryIdentifier = StringUtils.formatIdentifier(newBiome.field_76791_y, true, !CraftPresence.CONFIG.advancedSettings.formatWords);
        String newBiome_alternativeIdentifier = StringUtils.formatIdentifier(MappingUtils.getClassName(newBiome), true, !CraftPresence.CONFIG.advancedSettings.formatWords);
        String newBiome_Identifier = StringUtils.getOrDefault(newBiome_primaryIdentifier, newBiome_alternativeIdentifier);
        if (!newBiomeName.equals(this.CURRENT_BIOME_NAME) || !newBiome_Identifier.equals(this.CURRENT_BIOME_IDENTIFIER)) {
            this.CURRENT_BIOME = newBiome;
            this.CURRENT_BIOME_NAME = StringUtils.getOrDefault(newBiomeName, newBiome_Identifier);
            this.CURRENT_BIOME_IDENTIFIER = newBiome_Identifier;
            if (!this.DEFAULT_NAMES.contains(newBiome_Identifier)) {
                this.DEFAULT_NAMES.add(newBiome_Identifier);
            }
            if (!this.BIOME_NAMES.contains(newBiome_Identifier)) {
                this.BIOME_NAMES.add(newBiome_Identifier);
            }
            if (!this.BIOME_TYPES.contains(newBiome)) {
                this.BIOME_TYPES.add(newBiome);
            }
            this.updatePresence();
        }
    }

    @Override
    public void updatePresence() {
        ModuleData defaultData = CraftPresence.CONFIG.biomeSettings.biomeData.get("default");
        ModuleData currentData = CraftPresence.CONFIG.biomeSettings.biomeData.get(this.CURRENT_BIOME_IDENTIFIER);
        String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
        String currentMessage = Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage;
        String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_BIOME_IDENTIFIER;
        String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
        String formattedIcon = CraftPresence.CLIENT.imageOf("biome.icon", true, currentIcon, CraftPresence.CONFIG.biomeSettings.fallbackBiomeIcon);
        CraftPresence.CLIENT.syncArgument("biome.default.icon", CraftPresence.CONFIG.biomeSettings.fallbackBiomeIcon);
        CraftPresence.CLIENT.syncArgument("data.biome.instance", this.CURRENT_BIOME);
        CraftPresence.CLIENT.syncArgument("data.biome.class", this.CURRENT_BIOME.getClass());
        CraftPresence.CLIENT.syncArgument("biome.name", this.CURRENT_BIOME_NAME);
        CraftPresence.CLIENT.syncOverride(currentData != null ? currentData : defaultData, "biome.message", "biome.icon");
        CraftPresence.CLIENT.syncArgument("biome.message", currentMessage);
        CraftPresence.CLIENT.syncArgument("biome.icon", formattedIcon);
        CraftPresence.CLIENT.syncTimestamp("data.biome.time");
    }

    private List<BiomeGenBase> getBiomeTypes() {
        List<BiomeGenBase> biomeTypes = StringUtils.newArrayList();
        if (BiomeGenBase.func_150565_n() != null) {
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null || biomeTypes.contains(biome)) continue;
                biomeTypes.add(biome);
            }
        }
        if (biomeTypes.isEmpty()) {
            for (ClassInfo classInfo : FileUtils.getClassNamesMatchingSuperType(BiomeGenBase.class, CraftPresence.CONFIG.advancedSettings.includeExtraGuiClasses, new String[0]).values()) {
                if (classInfo == null) continue;
                try {
                    BiomeGenBase biomeObj;
                    Class<?> classObj = FileUtils.findValidClass(MappingUtils.CLASS_LOADER, true, classInfo.getName());
                    if (classObj == null || biomeTypes.contains(biomeObj = (BiomeGenBase)classObj.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]))) continue;
                    biomeTypes.add(biomeObj);
                }
                catch (Throwable ex) {
                    if (!CommandUtils.isVerboseMode()) continue;
                    ex.printStackTrace();
                }
            }
        }
        return biomeTypes;
    }

    @Override
    public void getAllData() {
        for (BiomeGenBase biome : this.getBiomeTypes()) {
            if (biome == null) continue;
            String biomeName = StringUtils.getOrDefault(biome.field_76791_y, MappingUtils.getClassName(biome));
            String name = StringUtils.formatIdentifier(biomeName, true, !CraftPresence.CONFIG.advancedSettings.formatWords);
            if (!this.DEFAULT_NAMES.contains(name)) {
                this.DEFAULT_NAMES.add(name);
            }
            if (!this.BIOME_NAMES.contains(name)) {
                this.BIOME_NAMES.add(name);
            }
            if (this.BIOME_TYPES.contains(biome)) continue;
            this.BIOME_TYPES.add(biome);
        }
        for (String biomeEntry : CraftPresence.CONFIG.biomeSettings.biomeData.keySet()) {
            String name;
            if (StringUtils.isNullOrEmpty(biomeEntry) || this.BIOME_NAMES.contains(name = StringUtils.formatIdentifier(biomeEntry, true, !CraftPresence.CONFIG.advancedSettings.formatWords))) continue;
            this.BIOME_NAMES.add(name);
        }
    }

    @Override
    public boolean canFetchData() {
        return FileUtils.canScanClasses();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }
}

