/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.EntityButterfly;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;

public abstract class AIButterflyBase
extends EntityAIBase {
    protected final EntityButterfly entity;

    protected AIButterflyBase(EntityButterfly entity) {
        this.entity = entity;
    }

    protected Vec3 getRandomDestination() {
        if (this.entity.func_70090_H()) {
            return this.getRandomDestinationUpwards();
        }
        Vec3 randomTarget = RandomPositionGenerator.func_75461_b((EntityCreature)this.entity, (int)16, (int)7, (Vec3)Vec3.func_72443_a((double)this.entity.field_70165_t, (double)this.entity.field_70163_u, (double)this.entity.field_70161_v));
        if (randomTarget == null) {
            return null;
        }
        if (this.validateDestination(randomTarget, false)) {
            return randomTarget;
        }
        return null;
    }

    protected Vec3 getRandomDestinationUpwards() {
        Vec3 destination = Vec3.func_72443_a((double)this.entity.field_70165_t, (double)(this.entity.field_70163_u + (double)this.entity.func_70681_au().nextInt(10) + 2.0), (double)this.entity.field_70161_v);
        if (this.validateDestination(destination, true)) {
            return destination;
        }
        return null;
    }

    private boolean validateDestination(Vec3 dest, boolean allowFluids) {
        if (dest.field_72448_b < 1.0) {
            return false;
        }
        Block block = this.entity.field_70170_p.func_147439_a((int)dest.field_72450_a, (int)dest.field_72448_b, (int)dest.field_72449_c);
        if (!allowFluids && block.func_149688_o().func_76224_d()) {
            return false;
        }
        if (!block.func_149655_b((IBlockAccess)this.entity.field_70170_p, (int)dest.field_72450_a, (int)dest.field_72448_b, (int)dest.field_72449_c)) {
            return false;
        }
        return this.entity.getButterfly().isAcceptedEnvironment(this.entity.field_70170_p, dest.field_72450_a, dest.field_72448_b, dest.field_72449_c);
    }
}

