/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.entity.ai.batking;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.entity.monster.EntityBatKing;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;

public class EntityAIBatKingAttack
extends EntityAIBase {
    private final Ranged mRangedAI;
    private final Melee mMeleeAI;
    private boolean mIsMelee = false;
    private final EntityBatKing mAttackingEntity;
    private PathEntity mEntityPathEntity;
    private EntityLivingBase mEntityTarget;
    private final Class mClassTarget;

    public EntityAIBatKingAttack(EntityBatKing aAttacker, Class aClassTarget, double aMovementSpeed, int someInt, int aMaxRangedAttackTime, float someFloat, boolean aLongMemory) {
        this.mRangedAI = new Ranged(this, aMovementSpeed, someInt, 5, someFloat);
        this.mMeleeAI = new Melee(this, aClassTarget, aMovementSpeed, aLongMemory);
        this.mAttackingEntity = aAttacker;
        this.mClassTarget = aClassTarget;
    }

    public boolean func_75250_a() {
        this.determineCombatStyle();
        EntityLivingBase entitylivingbase = this.mAttackingEntity.func_70638_az();
        if (entitylivingbase == null) {
            this.mEntityTarget = null;
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (this.mClassTarget != null && !this.mClassTarget.isAssignableFrom(entitylivingbase.getClass())) {
            return false;
        }
        if (this.mIsMelee) {
            return this.mMeleeAI.shouldExecute();
        }
        this.mEntityTarget = entitylivingbase;
        this.mEntityPathEntity = this.mAttackingEntity.func_70661_as().func_75494_a((Entity)entitylivingbase);
        return this.mRangedAI != null && this.mMeleeAI != null && this.hasValidTarget();
    }

    public EntityBatKing getBatKing() {
        return this.mAttackingEntity;
    }

    public IRangedAttackMob getBatKingAsIRangedAttackMob() {
        return this.mAttackingEntity;
    }

    public boolean hasValidTarget() {
        return this.mEntityTarget != null;
    }

    public EntityLivingBase getTarget() {
        return this.mEntityTarget;
    }

    public boolean func_75253_b() {
        this.determineCombatStyle();
        if (this.mIsMelee) {
            return this.mMeleeAI.continueExecuting();
        }
        return this.mRangedAI.continueExecuting();
    }

    public boolean func_75252_g() {
        if (this.mIsMelee) {
            // empty if block
        }
        return super.func_75252_g();
    }

    public void func_75249_e() {
        this.determineCombatStyle();
        if (this.mIsMelee) {
            this.mMeleeAI.startExecuting();
        } else {
            this.mRangedAI.startExecuting();
        }
    }

    public void func_75251_c() {
        this.determineCombatStyle();
        if (this.mIsMelee) {
            this.mMeleeAI.resetTask();
        } else {
            this.mRangedAI.resetTask();
        }
    }

    public void func_75246_d() {
        this.determineCombatStyle();
        if (this.mIsMelee) {
            this.mMeleeAI.updateTask();
        } else {
            this.mRangedAI.updateTask();
        }
    }

    private final void determineCombatStyle() {
        boolean aisMeleeNow = this.mIsMelee;
        this.mIsMelee = this.mEntityTarget != null && EntityUtils.getDistance((Entity)this.getBatKing(), (Entity)this.mEntityTarget) < 4.0;
        if (aisMeleeNow != this.mIsMelee) {
            Logger.INFO("Bat King changed combat style from " + (aisMeleeNow ? "Melee" : "Ranged") + " to " + (this.mIsMelee ? "Melee" : "Ranged"));
        }
    }

    private class Ranged {
        private final EntityAIBatKingAttack parentAI;
        private int rangedAttackTime = -1;
        private double entityMoveSpeed;
        private int mCooldownTime;
        private int field_96561_g;
        private int maxRangedAttackTime;
        private float field_96562_i;
        private float field_82642_h;

        public Ranged(EntityAIBatKingAttack aParent, double aMovementSpeed, int someInt, int aMaxRangedAttackTime, float someFloat) {
            this.parentAI = aParent;
            this.entityMoveSpeed = aMovementSpeed;
            this.field_96561_g = someInt;
            this.maxRangedAttackTime = aMaxRangedAttackTime;
            this.field_96562_i = someFloat;
            this.field_82642_h = someFloat * someFloat * 8.0f;
            this.parentAI.func_75248_a(3);
        }

        public void startExecuting() {
            this.parentAI.getBatKing().func_70661_as().func_75484_a(this.parentAI.mEntityPathEntity, this.entityMoveSpeed);
        }

        public boolean continueExecuting() {
            return this.parentAI.func_75250_a() || !this.parentAI.getBatKing().func_70661_as().func_75500_f();
        }

        public void resetTask() {
            this.parentAI.mEntityTarget = null;
            this.mCooldownTime = 0;
            this.rangedAttackTime = -1;
        }

        public void updateTask() {
            if (MathUtils.randInt(0, 100) == 0) {
                this.maxRangedAttackTime = MathUtils.balance(this.maxRangedAttackTime, 20, 40);
            }
            double d0 = this.parentAI.getBatKing().func_70092_e(((EntityAIBatKingAttack)this.parentAI).mEntityTarget.field_70165_t, ((EntityAIBatKingAttack)this.parentAI).mEntityTarget.field_70121_D.field_72338_b, ((EntityAIBatKingAttack)this.parentAI).mEntityTarget.field_70161_v);
            boolean flag = this.parentAI.getBatKing().func_70635_at().func_75522_a((Entity)this.parentAI.mEntityTarget);
            this.mCooldownTime = flag ? ++this.mCooldownTime : 0;
            if (d0 <= (double)this.field_82642_h && this.mCooldownTime >= 20) {
                this.parentAI.getBatKing().func_70661_as().func_75499_g();
            } else if (this.parentAI.getBatKing().func_70661_as().func_75497_a((Entity)this.parentAI.mEntityTarget, this.entityMoveSpeed)) {
                Logger.INFO("Doing Ranged Ai Task.");
            } else {
                Logger.INFO("Not Doing Ranged Ai Task.");
            }
            this.parentAI.getBatKing().func_70671_ap().func_75651_a((Entity)this.parentAI.mEntityTarget, 30.0f, 30.0f);
            Logger.INFO("Ranged AI - " + this.rangedAttackTime);
            if (--this.rangedAttackTime == 0) {
                float f;
                if (d0 > (double)this.field_82642_h || !flag) {
                    Logger.INFO("Stopping ranged attack. " + flag + "|" + (d0 > (double)this.field_82642_h) + "|" + d0 + "|" + (double)this.field_82642_h);
                    return;
                }
                float f1 = f = MathHelper.func_76133_a((double)d0) / this.field_96562_i;
                if (f < 0.1f) {
                    f1 = 0.1f;
                }
                if (f1 > 1.0f) {
                    f1 = 1.0f;
                }
                Logger.INFO("Trying to do a ranged attack.");
                this.parentAI.getBatKingAsIRangedAttackMob().func_82196_d(this.parentAI.mEntityTarget, f1);
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.field_96561_g) + (float)this.field_96561_g));
            } else if (this.rangedAttackTime < 0) {
                float f = MathHelper.func_76133_a((double)d0) / this.field_96562_i;
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.field_96561_g) + (float)this.field_96561_g));
            }
        }
    }

    private class Melee {
        private final EntityAIBatKingAttack parentAI;
        int attackTick;
        double speedTowardsTarget;
        boolean longMemory;
        Class classTarget;
        private int field_75445_i;
        private double field_151497_i;
        private double field_151495_j;
        private double field_151496_k;
        private int failedPathFindingPenalty;

        public Melee(EntityAIBatKingAttack aParent, Class aClassTarget, double aMoveToTargetSpeed, boolean aLongMemory) {
            this.parentAI = aParent;
            this.classTarget = aClassTarget;
            this.speedTowardsTarget = aMoveToTargetSpeed;
            this.longMemory = aLongMemory;
            this.parentAI.func_75248_a(3);
        }

        public boolean shouldExecute() {
            if (!this.parentAI.hasValidTarget()) {
                return false;
            }
            EntityLivingBase entitylivingbase = this.parentAI.getTarget();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (this.classTarget != null && !this.classTarget.isAssignableFrom(entitylivingbase.getClass())) {
                return false;
            }
            if (--this.field_75445_i <= 0) {
                this.parentAI.mEntityPathEntity = this.parentAI.mAttackingEntity.func_70661_as().func_75494_a((Entity)entitylivingbase);
                this.field_75445_i = 4 + this.parentAI.mAttackingEntity.func_70681_au().nextInt(7);
                return this.parentAI.mEntityPathEntity != null;
            }
            return true;
        }

        public boolean continueExecuting() {
            EntityLivingBase entitylivingbase = this.parentAI.mAttackingEntity.func_70638_az();
            return entitylivingbase == null ? false : (!entitylivingbase.func_70089_S() ? false : (!this.longMemory ? !this.parentAI.mAttackingEntity.func_70661_as().func_75500_f() : this.parentAI.mAttackingEntity.func_110176_b(MathHelper.func_76128_c((double)entitylivingbase.field_70165_t), MathHelper.func_76128_c((double)entitylivingbase.field_70163_u), MathHelper.func_76128_c((double)entitylivingbase.field_70161_v))));
        }

        public void startExecuting() {
            this.parentAI.mAttackingEntity.func_70661_as().func_75484_a(this.parentAI.mEntityPathEntity, this.speedTowardsTarget);
            this.field_75445_i = 0;
        }

        public void resetTask() {
            this.parentAI.mAttackingEntity.func_70661_as().func_75499_g();
        }

        public void updateTask() {
            EntityLivingBase entitylivingbase = this.parentAI.mAttackingEntity.func_70638_az();
            this.parentAI.mAttackingEntity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
            double d0 = this.parentAI.mAttackingEntity.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.field_70121_D.field_72338_b, entitylivingbase.field_70161_v);
            double d1 = ((EntityAIBatKingAttack)this.parentAI).mAttackingEntity.field_70130_N * 2.0f * ((EntityAIBatKingAttack)this.parentAI).mAttackingEntity.field_70130_N * 2.0f + entitylivingbase.field_70130_N;
            --this.field_75445_i;
            if ((this.longMemory || this.parentAI.mAttackingEntity.func_70635_at().func_75522_a((Entity)entitylivingbase)) && this.field_75445_i <= 0 && (this.field_151497_i == 0.0 && this.field_151495_j == 0.0 && this.field_151496_k == 0.0 || entitylivingbase.func_70092_e(this.field_151497_i, this.field_151495_j, this.field_151496_k) >= 1.0 || this.parentAI.mAttackingEntity.func_70681_au().nextFloat() < 0.05f)) {
                PathPoint finalPathPoint;
                this.field_151497_i = entitylivingbase.field_70165_t;
                this.field_151495_j = entitylivingbase.field_70121_D.field_72338_b;
                this.field_151496_k = entitylivingbase.field_70161_v;
                this.field_75445_i = this.failedPathFindingPenalty + 4 + this.parentAI.mAttackingEntity.func_70681_au().nextInt(7);
                this.failedPathFindingPenalty = this.parentAI.mAttackingEntity.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.parentAI.mAttackingEntity.func_70661_as().func_75505_d().func_75870_c()) != null && entitylivingbase.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                if (d0 > 1024.0) {
                    this.field_75445_i += 10;
                } else if (d0 > 256.0) {
                    this.field_75445_i += 5;
                }
                if (!this.parentAI.mAttackingEntity.func_70661_as().func_75497_a((Entity)entitylivingbase, this.speedTowardsTarget)) {
                    this.field_75445_i += 15;
                }
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            if (d0 <= d1 && this.attackTick <= 20) {
                this.attackTick = 20;
                if (this.parentAI.mAttackingEntity.func_70694_bm() != null) {
                    this.parentAI.mAttackingEntity.func_71038_i();
                }
                this.parentAI.mAttackingEntity.func_70652_k((Entity)entitylivingbase);
            }
        }
    }
}

