/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.tool.staballoy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.minecraft.MiningUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class StaballoyPickaxe
extends ItemPickaxe {
    protected int miningLevel;

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)stack.func_77952_i() / (double)stack.func_77958_k();
    }

    private static boolean createNBT(ItemStack rStack) {
        NBTTagCompound tagMain = new NBTTagCompound();
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74757_a("FACING_HORIZONTAL", true);
        tagNBT.func_74778_a("FACING", "north");
        tagNBT.func_74778_a("lookingDirection", "");
        tagMain.func_74782_a("PickStats", (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static final boolean isFacingHorizontal(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("PickStats")) != null) {
                return aNBT.func_74767_n("FACING_HORIZONTAL");
            }
        } else {
            StaballoyPickaxe.createNBT(aStack);
        }
        return true;
    }

    public static final boolean setFacingHorizontal(ItemStack aStack, boolean aFacingHorizontal) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("PickStats")) != null) {
            aNBT.func_74757_a("FACING_HORIZONTAL", aFacingHorizontal);
            return true;
        }
        return false;
    }

    public static final String getFacingDirection(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("PickStats")) != null) {
                return aNBT.func_74779_i("FACING");
            }
        } else {
            StaballoyPickaxe.createNBT(aStack);
        }
        return "north";
    }

    public static final boolean setFacingDirection(ItemStack aStack, String aFacingHorizontal) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("PickStats")) != null) {
            aNBT.func_74778_a("FACING", aFacingHorizontal);
            return true;
        }
        return false;
    }

    public static final String getLookingDirection(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("PickStats")) != null) {
                return aNBT.func_74779_i("lookingDirection");
            }
        } else {
            StaballoyPickaxe.createNBT(aStack);
        }
        return "";
    }

    public static final boolean setLookingDirection(ItemStack aStack, String aFacingHorizontal) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("PickStats")) != null) {
            aNBT.func_74778_a("lookingDirection", aFacingHorizontal);
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer aPlayer) {
        return super.func_77659_a(stack, world, aPlayer);
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int X, int Y, int Z, EntityLivingBase entity) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            this.GetDestroyOrientation((EntityPlayer)entity, block, StaballoyPickaxe.getLookingDirection(stack), world, X, Y, Z, stack);
        }
        return super.func_150894_a(stack, world, block, X, Y, Z, entity);
    }

    private float calculateDurabilityLoss(World world, int X, int Y, int Z) {
        float bDurabilityLoss = 0.0f;
        Boolean correctTool = false;
        float bHardness = 0.0f;
        if (!world.field_72995_K) {
            try {
                Block removalist = world.func_147439_a(X, Y, Z);
                bHardness = removalist.func_149712_f(world, X, Y, Z);
                Logger.WARNING("Hardness: " + bHardness);
                bDurabilityLoss += bHardness;
                correctTool = this.canPickaxeBlock(removalist, world, new int[]{X, Y, Z});
                Logger.WARNING("" + correctTool);
                if (!correctTool.booleanValue()) {
                    return 0.0f;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return 100.0f;
    }

    public Boolean canPickaxeBlock(Block currentBlock, World currentWorld, int[] xyz) {
        String correctTool = "";
        if (!currentWorld.field_72995_K) {
            try {
                correctTool = currentBlock.getHarvestTool(0);
                if (MiningUtils.getBlockType(currentBlock, currentWorld, xyz, this.miningLevel) || correctTool.equals("pickaxe") || correctTool.equals("null")) {
                    return true;
                }
            }
            catch (NullPointerException e) {
                return false;
            }
        }
        return false;
    }

    private void GetDestroyOrientation(EntityPlayer entity, Block block, String FACING, World world, int X, int Y, int Z, ItemStack heldItem) {
        float DURABILITY_LOSS = 0.0f;
        if (!world.field_72995_K) {
            float dur;
            int j;
            int i;
            Logger.WARNING("hardness:" + block.func_149712_f(world, X, Y, Z));
            if (FACING.equals("below") || FACING.equals("above")) {
                DURABILITY_LOSS = 0.0f;
                for (i = -1; i < 2; ++i) {
                    for (j = -1; j < 2; ++j) {
                        dur = this.calculateDurabilityLoss(world, X + i, Y, Z + j);
                        DURABILITY_LOSS += dur;
                        Logger.WARNING("Added Loss: " + dur);
                        this.removeBlockAndDropAsItem(world, X + i, Y, Z + j, heldItem);
                    }
                }
            } else if (FACING.equals("facingEast") || FACING.equals("facingWest")) {
                DURABILITY_LOSS = 0.0f;
                for (i = -1; i < 2; ++i) {
                    for (j = -1; j < 2; ++j) {
                        dur = this.calculateDurabilityLoss(world, X, Y + i, Z + j);
                        DURABILITY_LOSS += dur;
                        Logger.WARNING("Added Loss: " + dur);
                        this.removeBlockAndDropAsItem(world, X, Y + i, Z + j, heldItem);
                    }
                }
            } else if (FACING.equals("facingNorth") || FACING.equals("facingSouth")) {
                DURABILITY_LOSS = 0.0f;
                for (i = -1; i < 2; ++i) {
                    for (j = -1; j < 2; ++j) {
                        dur = this.calculateDurabilityLoss(world, X + j, Y + i, Z);
                        DURABILITY_LOSS += dur;
                        Logger.WARNING("Added Loss: " + dur);
                        this.removeBlockAndDropAsItem(world, X + j, Y + i, Z, heldItem);
                    }
                }
            }
            Logger.WARNING("Total Loss: " + (int)DURABILITY_LOSS);
            Logger.WARNING("1x: " + heldItem.func_77960_j());
            int itemdmg = heldItem.func_77960_j();
            int maxdmg = heldItem.func_77958_k();
            int dodmg = (int)DURABILITY_LOSS;
            int durNow = maxdmg - itemdmg;
            int durLeft = (int)((float)(maxdmg - itemdmg) - DURABILITY_LOSS);
            Logger.WARNING("Current Damage: " + itemdmg + " Max Damage: " + maxdmg + " Durability to be lost: " + dodmg + " Current Durability: " + durNow + " Remaining Durability: " + durLeft);
            if (durNow - dodmg <= 99 && itemdmg != 0) {
                Logger.WARNING("Breaking Tool");
                heldItem.field_77994_a = 0;
            } else {
                Logger.WARNING("" + (durNow - durLeft));
                this.damageItem(heldItem, durNow - durLeft - 1, entity);
            }
            DURABILITY_LOSS = 0.0f;
        }
    }

    public void damageItem(ItemStack item, int damage, EntityPlayer localPlayer) {
        item.func_77972_a(damage, (EntityLivingBase)localPlayer);
    }

    public void setItemDamage(ItemStack item, int damage) {
        item.func_77964_b(damage - 1);
    }

    public final void removeBlockAndDropAsItem(World world, int X, int Y, int Z, ItemStack heldItem) {
        try {
            Block block = world.func_147439_a(X, Y, Z);
            float dur = this.calculateDurabilityLoss(world, X, Y, Z);
            Logger.WARNING(block.toString());
            String removalTool = "";
            removalTool = block.getHarvestTool(1);
            Logger.WARNING("Removing.1 " + removalTool);
            if (this.canPickaxeBlock(block, world, new int[]{X, Y, Z}).booleanValue()) {
                Logger.WARNING("Removing.4");
                if (block == Blocks.field_150350_a) {
                    return;
                }
                if (block != Blocks.field_150357_h && block.func_149712_f(world, X, Y, Z) >= 0.0f && block.func_149712_f(world, X, Y, Z) <= 100.0f && block != Blocks.field_150355_j && block != Blocks.field_150353_l) {
                    Logger.WARNING("Removing.5");
                    if ((float)heldItem.func_77960_j() <= (float)heldItem.func_77958_k() - dur && (X != 0 || Y != 0 || Z != 0)) {
                        block.func_149697_b(world, X, Y, Z, world.func_72805_g(X, Y, Z), 0);
                        world.func_147468_f(X, Y, Z);
                    }
                }
            } else {
                Logger.WARNING("Incorrect Tool for mining this block.");
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean checkFacing(ItemStack aStack, EntityPlayer aPlayer, World world) {
        if (aPlayer != null) {
            int direction = MathHelper.func_76128_c((double)((double)(aPlayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            MovingObjectPosition movingobjectposition = this.func_77621_a(world, aPlayer, false);
            if (movingobjectposition != null) {
                int sideHit = movingobjectposition.field_72310_e;
                String playerStandingPosition = "";
                if (movingobjectposition != null) {
                    // empty if block
                }
                if (sideHit == 0) {
                    playerStandingPosition = "above";
                    StaballoyPickaxe.setFacingHorizontal(aStack, false);
                } else if (sideHit == 1) {
                    playerStandingPosition = "below";
                    StaballoyPickaxe.setFacingHorizontal(aStack, false);
                } else if (sideHit == 2) {
                    playerStandingPosition = "facingSouth";
                    StaballoyPickaxe.setFacingHorizontal(aStack, true);
                } else if (sideHit == 3) {
                    playerStandingPosition = "facingNorth";
                    StaballoyPickaxe.setFacingHorizontal(aStack, true);
                } else if (sideHit == 4) {
                    playerStandingPosition = "facingEast";
                    StaballoyPickaxe.setFacingHorizontal(aStack, true);
                } else if (sideHit == 5) {
                    playerStandingPosition = "facingWest";
                    StaballoyPickaxe.setFacingHorizontal(aStack, true);
                }
                StaballoyPickaxe.setLookingDirection(aStack, playerStandingPosition);
                if (direction == 0) {
                    StaballoyPickaxe.setFacingDirection(aStack, "south");
                } else if (direction == 1) {
                    StaballoyPickaxe.setFacingDirection(aStack, "west");
                } else if (direction == 2) {
                    StaballoyPickaxe.setFacingDirection(aStack, "north");
                } else if (direction == 3) {
                    StaballoyPickaxe.setFacingDirection(aStack, "east");
                }
            }
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        list.add(EnumChatFormatting.GRAY + "Mines a 3x3 at 100 durability per block mined.");
        list.add(EnumChatFormatting.GRAY + "Durability: " + (stack.func_77958_k() - stack.func_77960_j()) + "/" + stack.func_77958_k());
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer aPlayer) {
        this.checkFacing(itemstack, aPlayer, aPlayer.func_130014_f_());
        return super.onBlockStartBreak(itemstack, X, Y, Z, aPlayer);
    }

    public StaballoyPickaxe(String unlocalizedName, Item.ToolMaterial material) {
        super(material);
        this.func_77655_b(unlocalizedName);
        this.func_111206_d(Mods.GTPlusPlus.ID + ":" + unlocalizedName);
        this.func_77625_d(1);
        this.func_77656_e(3200);
        this.miningLevel = 5;
    }
}

