/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.recipe;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.HotFuel;
import gregtech.api.util.ThermalFuel;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.item.chemistry.AgriculturalChem;
import gtPlusPlus.core.item.chemistry.GenericChem;
import gtPlusPlus.core.item.chemistry.IonParticles;
import gtPlusPlus.core.item.chemistry.RocketFuels;
import gtPlusPlus.core.item.crafting.ItemDummyResearch;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.ALLOY;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.material.MISC_MATERIALS;
import gtPlusPlus.core.material.ORES;
import gtPlusPlus.core.material.Particle;
import gtPlusPlus.core.material.nuclear.FLUORIDES;
import gtPlusPlus.core.recipe.RECIPES_RareEarthProcessing;
import gtPlusPlus.core.recipe.RECIPES_SeleniumProcessing;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.EnchantingUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.xmod.bop.blocks.BOP_Block_Registrator;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RECIPES_GREGTECH {
    public static void run() {
        Logger.INFO("Loading Recipes through GregAPI for Industrial Multiblocks.");
        RECIPES_GREGTECH.execute();
    }

    private static void execute() {
        RECIPES_GREGTECH.electrolyzerRecipes();
        RECIPES_GREGTECH.assemblerRecipes();
        RECIPES_GREGTECH.fluidcannerRecipes();
        RECIPES_GREGTECH.distilleryRecipes();
        RECIPES_GREGTECH.extractorRecipes();
        RECIPES_GREGTECH.fluidExtractorRecipes();
        RECIPES_GREGTECH.chemicalBathRecipes();
        RECIPES_GREGTECH.chemicalReactorRecipes();
        RECIPES_GREGTECH.dehydratorRecipes();
        RECIPES_GREGTECH.blastFurnaceRecipes();
        RECIPES_GREGTECH.largeChemReactorRecipes();
        RECIPES_GREGTECH.fusionRecipes();
        RECIPES_GREGTECH.fissionFuelRecipes();
        RECIPES_GREGTECH.autoclaveRecipes();
        RECIPES_GREGTECH.compressorRecipes();
        RECIPES_GREGTECH.mixerRecipes();
        RECIPES_GREGTECH.macerationRecipes();
        RECIPES_GREGTECH.centrifugeRecipes();
        RECIPES_GREGTECH.benderRecipes();
        RECIPES_GREGTECH.cyclotronRecipes();
        RECIPES_GREGTECH.blastSmelterRecipes();
        RECIPES_GREGTECH.sifterRecipes();
        RECIPES_GREGTECH.electroMagneticSeperatorRecipes();
        RECIPES_GREGTECH.extruderRecipes();
        RECIPES_GREGTECH.cuttingSawRecipes();
        RECIPES_GREGTECH.breweryRecipes();
        RECIPES_GREGTECH.laserEngraverRecipes();
        RECIPES_GREGTECH.assemblyLineRecipes();
        RECIPES_GREGTECH.latheRecipes();
        RECIPES_GREGTECH.vacuumFreezerRecipes();
        RECIPES_GREGTECH.fluidheaterRecipes();
        RECIPES_GREGTECH.chemplantRecipes();
        RECIPES_GREGTECH.packagerRecipes();
        RECIPES_GREGTECH.alloySmelterRecipes();
        RECIPES_SeleniumProcessing.init();
        RECIPES_RareEarthProcessing.init();
        RECIPES_GREGTECH.addFuels();
    }

    private static void alloySmelterRecipes() {
        GT_Values.RA.addAlloySmelterRecipe(MISC_MATERIALS.WOODS_GLASS.getDust(5), ItemList.Shape_Mold_Ball.get(0L, new Object[0]), GregtechItemList.Laser_Lens_WoodsGlass.get(1L, new Object[0]), 6000, MaterialUtils.getVoltageForTier(3));
    }

    private static void packagerRecipes() {
    }

    private static void implosionRecipes() {
    }

    private static void chemplantRecipes() {
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(17), CI.getPinkCatalyst(0)}, new FluidStack[]{FluidUtils.getFluidStack(GenericChem.Nitrogen_Dioxide, 4000), FluidUtils.getAir(4000), FluidUtils.getWater(2000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack("nitricacid", 4000)}, 200, 480L, 3);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(17), CI.getPurpleCatalyst(0), ItemUtils.getSimpleStack(Blocks.field_150322_A, 64), ItemUtils.getSimpleStack(Blocks.field_150322_A, 64)}, new FluidStack[]{FluidUtils.getFluidStack("nitricacid", 4000), FluidUtils.getAir(8000)}, new ItemStack[]{FLUORIDES.FLUORITE.getOre(8), FLUORIDES.FLUORITE.getOre(4), FLUORIDES.FLUORITE.getOre(4), FLUORIDES.FLUORITE.getOre(4)}, new FluidStack[0], new int[]{0, 2500, 2000, 1500}, 200, 1024L, 5);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(17), CI.getPurpleCatalyst(0), ItemUtils.getSimpleStack((Block)Blocks.field_150354_m, 64), ItemUtils.getSimpleStack((Block)Blocks.field_150354_m, 64)}, new FluidStack[]{FluidUtils.getFluidStack("nitricacid", 5000), FluidUtils.getAir(12000)}, new ItemStack[]{FLUORIDES.FLUORITE.getOre(4), FLUORIDES.FLUORITE.getOre(2), FLUORIDES.FLUORITE.getOre(2), FLUORIDES.FLUORITE.getOre(2)}, new FluidStack[0], new int[]{7500, 1500, 1000, 500}, 200, 1024L, 5);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(16), CI.getPinkCatalyst(0)}, new FluidStack[]{FluidUtils.getFluidStack(GenericChem.Nitrogen_Dioxide, 3000), FluidUtils.getDistilledWater(1000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack("nitricacid", 2000), FluidUtils.getFluidStack(GenericChem.Nitric_Oxide, 1000)}, 200, 480L, 2);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(21), ItemUtils.getItemStackOfAmountFromOreDict("dustBorax", 23)}, new FluidStack[]{FluidUtils.getFluidStack(GenericChem.HydrochloricAcid, 2000)}, new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustSalt", 4)}, new FluidStack[]{FluidUtils.getFluidStack("boricacid", 4000), FluidUtils.getWater(5000)}, 600, MaterialUtils.getVoltageForTier(3), 3);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(22), ELEMENT.getInstance().THORIUM.getDust(16)}, new FluidStack[]{FluidUtils.getDistilledWater(2000), FluidUtils.getFluidStack("boricacid", 1500)}, new ItemStack[]{ELEMENT.getInstance().THORIUM.getSmallDust(32), ELEMENT.getInstance().THORIUM232.getDust(2), ELEMENT.getInstance().THORIUM232.getSmallDust(2), ELEMENT.getInstance().URANIUM232.getDust(1)}, new FluidStack[0], new int[]{0, 0, 1000, 250}, 6000, MaterialUtils.getVoltageForTier(4), 4);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedBioCircuit(6), ItemUtils.getSimpleStack(Blocks.field_150345_g, 32)}, new FluidStack[]{FluidUtils.getFluidStack("fluid.geneticmutagen", 2000), FluidUtils.getDistilledWater(8000)}, new ItemStack[]{ItemUtils.getSimpleStack(BOP_Block_Registrator.sapling_Pine, 16)}, new FluidStack[0], 2400, 64L, 2);
        if (Materials.Plutonium.mDefaultLocalName.equals("Plutonium 239")) {
            CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(16), ELEMENT.getInstance().PLUTONIUM239.getDust(1)}, new FluidStack[0], new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustPlutonium", 1)}, new FluidStack[0], 100, 1L, 2);
            CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(16), ELEMENT.getInstance().PLUTONIUM239.getSmallDust(1)}, new FluidStack[0], new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustSmallPlutonium", 1)}, new FluidStack[0], 100, 1L, 2);
            CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(16), ELEMENT.getInstance().PLUTONIUM239.getTinyDust(1)}, new FluidStack[0], new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustTinyPlutonium", 1)}, new FluidStack[0], 100, 1L, 2);
        }
        int aLaureniumTier = ALLOY.LAURENIUM.vTier;
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(12), CI.getTieredMachineCasing(aLaureniumTier - 1), ALLOY.LAURENIUM.getPlate(8), CI.getGear(aLaureniumTier, 2)}, new FluidStack[]{CI.getTieredFluid(aLaureniumTier, 288), CI.getAlternativeTieredFluid(aLaureniumTier - 1, 576), CI.getTertiaryTieredFluid(aLaureniumTier - 2, 864)}, new ItemStack[]{GregtechItemList.Casing_Machine_Custom_3.get(1L, new Object[0])}, new FluidStack[0], 400, MaterialUtils.getVoltageForTier(aLaureniumTier - 2), 5);
        int aBotmiumTier = ALLOY.BOTMIUM.vTier;
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(12), CI.getTieredMachineCasing(aBotmiumTier - 1), ALLOY.BOTMIUM.getPlate(8), CI.getGear(aBotmiumTier, 2)}, new FluidStack[]{CI.getTieredFluid(aBotmiumTier, 288), CI.getAlternativeTieredFluid(aBotmiumTier - 1, 576), CI.getTertiaryTieredFluid(aBotmiumTier - 2, 864)}, new ItemStack[]{GregtechItemList.Casing_Machine_Custom_4.get(1L, new Object[0])}, new FluidStack[0], 400, MaterialUtils.getVoltageForTier(aBotmiumTier - 2), 6);
        if (FluidUtils.doesHydrofluoricAcidGtExist()) {
            CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(22)}, new FluidStack[]{FluidUtils.getHydrofluoricAcid(2000), FluidUtils.getHydrofluoricAcidGT(5000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getHydrofluoricAcid(4500)}, 600, 480L, 3);
        }
    }

    private static void fluidheaterRecipes() {
        GT_Values.RA.addFluidHeaterRecipe(CI.getNumberedCircuit(20), FluidUtils.getWater(1000), FluidUtils.getHotWater(1000), 30, 30);
    }

    private static void vacuumFreezerRecipes() {
        GT_Values.RA.addVacuumFreezerRecipe(GregtechItemList.Bomb_Cast_Molten.get(1L, new Object[0]), GregtechItemList.Bomb_Cast_Set.get(1L, new Object[0]), 600);
    }

    private static void latheRecipes() {
        GT_Values.RA.addLatheRecipe(ALLOY.EGLIN_STEEL.getBlock(1), GregtechItemList.Bomb_Cast_Mold.get(1L, new Object[0]), null, 18000, 120);
        GT_Values.RA.addLatheRecipe(GregtechItemList.Bomb_Cast_Set.get(1L, new Object[0]), GregtechItemList.Bomb_Cast_Broken.get(2L, new Object[0]), ItemUtils.getSimpleStack(ModItems.itemBombCasing, 2), 6000, 30);
    }

    private static void fusionRecipes() {
        GT_Values.RA.addFusionReactorRecipe(ELEMENT.STANDALONE.DRAGON_METAL.getFluidStack(144), ELEMENT.STANDALONE.RHUGNOR.getFluidStack(288), ELEMENT.STANDALONE.HYPOGEN.getFluidStack(36), 8192, MaterialUtils.getVoltageForTier(9), 1200000000);
        GT_Values.RA.addFusionReactorRecipe(MaterialUtils.getMaterial("Infinity", "Neutronium").getMolten(144L), ALLOY.QUANTUM.getFluidStack(288), ELEMENT.STANDALONE.RHUGNOR.getFluidStack(144), 512, MaterialUtils.getVoltageForTier(8), 2000000000);
    }

    private static void assemblyLineRecipes() {
        ItemStack[] aCoilWire = new ItemStack[]{ItemUtils.simpleMetaStack("miscutils:itemDehydratorCoilWire", 0, 64), ItemUtils.simpleMetaStack("miscutils:itemDehydratorCoilWire", 1, 64), ItemUtils.simpleMetaStack("miscutils:itemDehydratorCoilWire", 2, 64), ItemUtils.simpleMetaStack("miscutils:itemDehydratorCoilWire", 3, 64)};
        CORE.RA.addAssemblylineRecipe(ItemDummyResearch.getResearchStack(ItemDummyResearch.ASSEMBLY_LINE_RESEARCH.RESEARCH_1_CONTAINMENT, 1), 36000, new Object[]{ItemList.Field_Generator_IV.get(32L, new Object[0]), ItemList.Electric_Motor_EV.get(64L, new Object[0]), ItemList.Energy_LapotronicOrb.get(32L, new Object[0]), CI.getTieredComponent(OrePrefixes.cableGt12, 7, 32), CI.getTieredComponent(OrePrefixes.wireGt16, 6, 64), ItemUtils.getOrePrefixStack(OrePrefixes.plate, Materials.Naquadria, 64), ELEMENT.getInstance().GADOLINIUM.getDust(32), ELEMENT.getInstance().SAMARIUM.getDust(16), ALLOY.ARCANITE.getGear(8), new Object[]{CI.getTieredCircuitOreDictName(5), 64}, new Object[]{CI.getTieredCircuitOreDictName(6), 32}, new Object[]{CI.getTieredCircuitOreDictName(7), 16}, GregtechItemList.Laser_Lens_Special.get(1L, new Object[0]), aCoilWire[3]}, new FluidStack[]{ALLOY.NITINOL_60.getFluidStack(5184), ALLOY.ENERGYCRYSTAL.getFluidStack(10368), ALLOY.TUMBAGA.getFluidStack(41472), ALLOY.NICHROME.getFluidStack(2304)}, ItemUtils.getSimpleStack(ModBlocks.blockCasings3Misc, 15, 32), 24000, MaterialUtils.getVoltageForTier(6));
        CORE.RA.addAssemblylineRecipe(ItemDummyResearch.getResearchStack(ItemDummyResearch.ASSEMBLY_LINE_RESEARCH.RESEARCH_8_TURBINE_AUTOMATION, 1), 1728000, new Object[]{CI.getTieredMachineHull(8, 4), CI.getConveyor(8, 24), CI.getElectricMotor(7, 32), CI.getElectricPiston(7, 16), CI.getEnergyCore(6, 8), CI.getPlate(8, 24), CI.getTieredComponent(OrePrefixes.screw, 8, 48), CI.getTieredComponent(OrePrefixes.bolt, 7, 32), CI.getTieredComponent(OrePrefixes.rod, 6, 12), new Object[]{CI.getTieredCircuitOreDictName(7), 20}, CI.getTieredComponent(OrePrefixes.rotor, 6, 16)}, new FluidStack[]{CI.getTieredFluid(8, 4608), CI.getAlternativeTieredFluid(7, 2304), CI.getTertiaryTieredFluid(7, 2304), ALLOY.BABBIT_ALLOY.getFluidStack(18432)}, GregtechItemList.Hatch_Input_TurbineHousing.get(4L, new Object[0]), 144000, MaterialUtils.getVoltageForTier(8));
        ItemStack[] aGemCasings = new ItemStack[]{GregtechItemList.Battery_Casing_Gem_1.get(1L, new Object[0]), GregtechItemList.Battery_Casing_Gem_2.get(1L, new Object[0]), GregtechItemList.Battery_Casing_Gem_3.get(1L, new Object[0]), GregtechItemList.Battery_Casing_Gem_4.get(1L, new Object[0])};
        ItemStack[] aResearch = new ItemStack[]{Particle.getBaseParticle(Particle.UNKNOWN), GregtechItemList.Battery_Casing_Gem_1.get(1L, new Object[0]), GregtechItemList.Battery_Casing_Gem_2.get(1L, new Object[0]), GregtechItemList.Battery_Casing_Gem_3.get(1L, new Object[0])};
        int aCasingSlot = 0;
        for (int j = 6; j < 10; ++j) {
            CORE.RA.addAssemblylineRecipe(aResearch[aCasingSlot], 72000, new ItemStack[]{CI.getTieredComponent(OrePrefixes.plate, j - 1, 16), CI.getTieredComponent(OrePrefixes.cableGt08, j + 1, 32), CI.getTieredComponent(OrePrefixes.gearGt, j - 1, 4), aCoilWire[aCasingSlot]}, new FluidStack[]{CI.getTieredFluid(j, 1152), CI.getTertiaryTieredFluid(j - 2, 2304), CI.getAlternativeTieredFluid(j, 2304)}, aGemCasings[aCasingSlot++], 2400, MaterialUtils.getVoltageForTier(j));
        }
        ItemStack[] aGemBatteries = new ItemStack[]{GregtechItemList.Battery_Gem_1.get(1L, new Object[0]), GregtechItemList.Battery_Gem_2.get(1L, new Object[0]), GregtechItemList.Battery_Gem_3.get(1L, new Object[0]), GregtechItemList.Battery_Gem_4.get(1L, new Object[0])};
        ItemStack[] aExoticInputs = new ItemStack[]{Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.ELECTRON), Particle.getBaseParticle(Particle.CHARM), Particle.getBaseParticle(Particle.GRAVITON)};
        aCasingSlot = 0;
        for (int j = 6; j < 10; ++j) {
            CORE.RA.addAssemblylineRecipe(aExoticInputs[aCasingSlot], 360000, new Object[]{aGemCasings[aCasingSlot], ItemUtils.getSimpleStack(aExoticInputs[aCasingSlot], 16), CI.getTieredComponent(OrePrefixes.plate, j, 16), new Object[]{CI.getTieredCircuitOreDictName(j), 8}, CI.getTieredComponent(OrePrefixes.wireGt16, j + 1, 32), CI.getTieredComponent(OrePrefixes.bolt, j, 8), CI.getTieredComponent(OrePrefixes.screw, j - 1, 8)}, new FluidStack[]{CI.getTieredFluid(j, 2304), CI.getTertiaryTieredFluid(j - 2, 4608), CI.getAlternativeTieredFluid(j, 2304), CI.getTertiaryTieredFluid(j - 1, 2304)}, aGemBatteries[aCasingSlot++], 2400, MaterialUtils.getVoltageForTier(j));
        }
        if (Mods.Baubles.isModLoaded()) {
            CORE.RA.addAssemblylineRecipe(ItemUtils.simpleMetaStack(Items.field_151153_ao, 1, 1), 12000, new Object[]{ItemUtils.getSimpleStack(aGemCasings[2], 4), CI.getTieredComponent(OrePrefixes.plate, 8, 32), new Object[]{CI.getTieredCircuitOreDictName(7), 16}, CI.getTieredComponent(OrePrefixes.cableGt02, 7, 16), CI.getTieredComponent(OrePrefixes.gearGt, 6, 6), CI.getTieredComponent(OrePrefixes.screw, 7, 16), CI.getTieredComponent(OrePrefixes.bolt, 5, 24), CI.getTieredComponent(OrePrefixes.frameGt, 4, 12), aCoilWire[3]}, new FluidStack[]{CI.getTieredFluid(7, 41472), CI.getTertiaryTieredFluid(7, 41472), CI.getAlternativeTieredFluid(6, 41472), CI.getAlternativeTieredFluid(7, 41472)}, ItemUtils.getItemStackFromFQRN("miscutils:personalHealingDevice", 1), 72000, MaterialUtils.getVoltageForTier(7));
            ItemStack[] aChargeResearch = new ItemStack[]{ItemUtils.getItemStackFromFQRN("miscutils:item.itemBufferCore7", 1), ItemUtils.getItemStackFromFQRN("miscutils:item.itemBufferCore8", 1), ItemUtils.getItemStackFromFQRN("miscutils:item.itemBufferCore9", 1), ItemUtils.getItemStackFromFQRN("miscutils:item.itemBufferCore10", 1)};
            ItemStack[] aChargeOutputs = new ItemStack[]{ItemUtils.getSimpleStack(ModItems.itemChargePack_High_1, 1), ItemUtils.getSimpleStack(ModItems.itemChargePack_High_2, 1), ItemUtils.getSimpleStack(ModItems.itemChargePack_High_3, 1), ItemUtils.getSimpleStack(ModItems.itemChargePack_High_4, 1)};
            int aCurrSlot = 0;
            for (int h = 6; h < 10; ++h) {
                CORE.RA.addAssemblylineRecipe(aChargeResearch[aCurrSlot], 12000 * (aCurrSlot + 1), new Object[]{ItemUtils.getSimpleStack(aGemBatteries[aCurrSlot], 2), aCoilWire[aCurrSlot], CI.getTieredComponent(OrePrefixes.plate, h, 8), new Object[]{CI.getTieredCircuitOreDictName(h), 4}, new Object[]{CI.getTieredCircuitOreDictName(h - 1), 8}, CI.getTieredComponent(OrePrefixes.cableGt12, h - 1, 16), CI.getTieredComponent(OrePrefixes.screw, h, 16), CI.getTieredComponent(OrePrefixes.bolt, h - 2, 32), CI.getFieldGenerator(h, 1)}, new FluidStack[]{CI.getTieredFluid(h, 4608), CI.getTertiaryTieredFluid(h - 1, 4608), CI.getAlternativeTieredFluid(h - 1, 4608), CI.getAlternativeTieredFluid(h - 2, 4608)}, aChargeOutputs[aCurrSlot], 72000 * (aCurrSlot + 1), MaterialUtils.getVoltageForTier(h));
                ++aCurrSlot;
            }
            CORE.RA.addAssemblylineRecipe(ItemDummyResearch.getResearchStack(ItemDummyResearch.ASSEMBLY_LINE_RESEARCH.RESEARCH_9_CLOAKING, 1), 12000, new Object[]{ItemUtils.getSimpleStack(aGemCasings[3], 4), CI.getTieredComponent(OrePrefixes.plate, 8, 32), new Object[]{CI.getTieredCircuitOreDictName(7), 16}, CI.getTieredComponent(OrePrefixes.cableGt04, 8, 16), CI.getTieredComponent(OrePrefixes.gearGt, 7, 6), CI.getTieredComponent(OrePrefixes.screw, 8, 16), CI.getTieredComponent(OrePrefixes.bolt, 7, 24), CI.getTieredComponent(OrePrefixes.frameGt, 5, 12), aCoilWire[3]}, new FluidStack[]{CI.getTieredFluid(8, 41472), CI.getTertiaryTieredFluid(8, 41472), CI.getAlternativeTieredFluid(7, 41472), CI.getAlternativeTieredFluid(8, 41472)}, ItemUtils.getItemStackFromFQRN("miscutils:personalCloakingDevice", 1), 72000, MaterialUtils.getVoltageForTier(8));
        }
        GT_Values.RA.addAssemblylineRecipe(GregtechItemList.Industrial_AlloyBlastSmelter.get(1L, new Object(){}), 36000, new Object[]{GregtechItemList.Industrial_AlloyBlastSmelter.get(64L, new Object(){}), GregtechItemList.Industrial_AlloyBlastSmelter.get(64L, new Object(){}), GregtechItemList.Industrial_AlloyBlastSmelter.get(64L, new Object(){}), GregtechItemList.Industrial_AlloyBlastSmelter.get(64L, new Object(){}), ItemList.UV_Coil.get(16L, new Object[]{new Object(){}}), ItemList.Conveyor_Module_UV.get(4L, new Object[]{new Object(){}}), new Object[]{OrePrefixes.circuit.get((Object)Materials.SuperconductorUHV), 8}, new Object[]{OrePrefixes.circuit.get((Object)Materials.Ultimate), 16}, ItemList.Circuit_Chip_PPIC.get(16L, new Object[]{new Object(){}}), ALLOY.PIKYONIUM.getPlate(16), ALLOY.CINOBITE.getScrew(32)}, new FluidStack[]{ALLOY.PIKYONIUM.getFluidStack(1152), ALLOY.INDALLOY_140.getFluidStack(1296), Materials.SolderingAlloy.getMolten(1440L)}, GregtechItemList.Mega_AlloyBlastSmelter.get(1L, new Object[0]), 1200, 1000000);
    }

    private static void laserEngraverRecipes() {
        GregtechItemList[] aTransParts = new GregtechItemList[]{GregtechItemList.TransmissionComponent_ULV, GregtechItemList.TransmissionComponent_LV, GregtechItemList.TransmissionComponent_MV, GregtechItemList.TransmissionComponent_HV, GregtechItemList.TransmissionComponent_EV, GregtechItemList.TransmissionComponent_IV, GregtechItemList.TransmissionComponent_LuV, GregtechItemList.TransmissionComponent_ZPM, GregtechItemList.TransmissionComponent_UV, GregtechItemList.TransmissionComponent_MAX};
        for (int i = 0; i < 10; ++i) {
            GT_Values.RA.addLaserEngraverRecipe(CI.getEmitter(i, 2), CI.getSensor(i, 2), aTransParts[i].get(1L, new Object[0]), 100, MaterialUtils.getVoltageForTier(i));
        }
        GT_Values.RA.addLaserEngraverRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Tungsten, (long)6L), GregtechItemList.Laser_Lens_Special.get(0L, new Object[0]), ELEMENT.STANDALONE.CELESTIAL_TUNGSTEN.getDust(1), 3600, MaterialUtils.getVoltageForTier(ELEMENT.STANDALONE.CELESTIAL_TUNGSTEN.vTier));
        GT_Values.RA.addLaserEngraverRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Titanium, (long)8L), GregtechItemList.Laser_Lens_Special.get(0L, new Object[0]), ELEMENT.STANDALONE.ASTRAL_TITANIUM.getDust(1), 2400, MaterialUtils.getVoltageForTier(ELEMENT.STANDALONE.ASTRAL_TITANIUM.vTier));
        GT_Values.RA.addLaserEngraverRecipe(ALLOY.NITINOL_60.getBlock(2), GregtechItemList.Laser_Lens_Special.get(0L, new Object[0]), ELEMENT.STANDALONE.ADVANCED_NITINOL.getBlock(1), 1200, MaterialUtils.getVoltageForTier(ELEMENT.STANDALONE.ADVANCED_NITINOL.vTier));
        GT_Values.RA.addLaserEngraverRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Glass, (long)64L), GregtechItemList.Laser_Lens_Special.get(0L, new Object[0]), ELEMENT.STANDALONE.CHRONOMATIC_GLASS.getDust(1), 6000, MaterialUtils.getVoltageForTier(ELEMENT.STANDALONE.CHRONOMATIC_GLASS.vTier));
        GT_Values.RA.addLaserEngraverRecipe(CI.getFieldGenerator(6, 1), CI.getEmitter(7, 2), ItemDummyResearch.getResearchStack(ItemDummyResearch.ASSEMBLY_LINE_RESEARCH.RESEARCH_1_CONTAINMENT, 1), 6000, MaterialUtils.getVoltageForTier(5));
        GT_Values.RA.addLaserEngraverRecipe(GregtechItemList.Laser_Lens_WoodsGlass.get(0L, new Object[0]), ItemUtils.simpleMetaStack(AgriculturalChem.mBioCircuit, 20, 1), GregtechItemList.Distillus_Upgrade_Chip.get(1L, new Object[0]), 6000, MaterialUtils.getVoltageForTier(5));
    }

    private static void breweryRecipes() {
        CORE.RA.addBrewingRecipe(14, EnchantingUtils.getMobEssence(100), EnchantingUtils.getLiquidXP(1332), 100, 120, false);
        CORE.RA.addBrewingRecipe(14, EnchantingUtils.getLiquidXP(1332), EnchantingUtils.getMobEssence(100), 100, 120, false);
        CORE.RA.addBrewingRecipe(ItemUtils.getSimpleStack(BOP_Block_Registrator.sapling_Rainforest), FluidUtils.getFluidStack("water", 100), FluidUtils.getFluidStack("biomass", 100), 1200, 3, false);
        CORE.RA.addBrewingRecipe(ItemUtils.getSimpleStack(BOP_Block_Registrator.sapling_Rainforest), FluidUtils.getFluidStack("honey", 100), FluidUtils.getFluidStack("biomass", 150), 1200, 3, false);
        CORE.RA.addBrewingRecipe(ItemUtils.getSimpleStack(BOP_Block_Registrator.sapling_Rainforest), FluidUtils.getFluidStack("juice", 100), FluidUtils.getFluidStack("biomass", 150), 1200, 3, false);
    }

    private static void cuttingSawRecipes() {
        GT_Values.RA.addCutterRecipe(ItemUtils.getItemStackOfAmountFromOreDict("blockMeatRaw", 1), ItemUtils.getItemStackOfAmountFromOreDict("plateMeatRaw", 9), null, 16, 8);
    }

    private static void electrolyzerRecipes() {
        GT_Values.RA.addElectrolyzerRecipe(ItemUtils.getSimpleStack(ModItems.dustDecayedRadium226, 1), null, null, FluidUtils.getFluidStack("radon", 144), null, null, null, null, null, null, new int[0], 1800, 240);
    }

    private static void extruderRecipes() {
        if (GT_Values.RA.addExtruderRecipe(ItemUtils.getItemStackOfAmountFromOreDict("blockOsmium", 1), ItemList.Shape_Mold_Credit.get(0L, new Object[0]), ItemList.Credit_Greg_Osmium.get(1L, new Object[0]), (int)Math.max(Materials.Osmium.getMass() * 2L * 20L, 1L), 1024)) {
            Logger.WARNING("Extruder Recipe: Osmium Credit - Success");
        } else {
            Logger.WARNING("Extruder Recipe: Osmium Credit - Failed");
        }
    }

    private static void blastSmelterRecipes() {
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(6), ELEMENT.getInstance().IRON.getDust(4), ALLOY.KANTHAL.getDust(1), ALLOY.INVAR.getDust(5), ELEMENT.getInstance().SULFUR.getDust(1), ELEMENT.getInstance().CARBON.getDust(1), ELEMENT.getInstance().SILICON.getDust(4)}, ALLOY.EGLIN_STEEL.getFluidStack(2304), 0, 900, 120);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(5), ELEMENT.getInstance().BARIUM.getDust(2), ELEMENT.getInstance().CALCIUM.getDust(2), ELEMENT.getInstance().COPPER.getDust(3)}, new FluidStack[]{ELEMENT.getInstance().OXYGEN.getFluidStack(8000), ELEMENT.getInstance().MERCURY.getFluidStack(1000)}, ALLOY.HG1223.getFluidStack(2304), null, new int[]{10000}, 2400, 30720);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(2), ELEMENT.getInstance().TITANIUM.getDust(3), ELEMENT.getInstance().NICKEL.getDust(2)}, ALLOY.NITINOL_60.getFluidStack(720), 0, 1500, 7680);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(5), ELEMENT.getInstance().BISMUTH.getDust(47), ELEMENT.getInstance().LEAD.getDust(25), ELEMENT.getInstance().TIN.getDust(13), ELEMENT.getInstance().CADMIUM.getDust(10), ELEMENT.getInstance().INDIUM.getDust(5)}, ALLOY.INDALLOY_140.getFluidStack(14400), 0, 800, 7680);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(15), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedSphalerite", 8), ELEMENT.getInstance().CARBON.getDust(32)}, Materials.SulfuricAcid.getFluid(2000L), ELEMENT.getInstance().GERMANIUM.getFluidStack(288), 0, 6000, 4000);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(19), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedIridium", 8), ELEMENT.getInstance().CARBON.getDust(32)}, Materials.SulfuricAcid.getFluid(2000L), ELEMENT.getInstance().RUTHENIUM.getFluidStack(288), 0, 6000, 8000);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(19), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedOsmium", 8), ELEMENT.getInstance().CARBON.getDust(32)}, Materials.SulfuricAcid.getFluid(2000L), ELEMENT.getInstance().RUTHENIUM.getFluidStack(288), 0, 6000, 8000);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(19), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedPlatinum", 8), ELEMENT.getInstance().CARBON.getDust(32)}, Materials.SulfuricAcid.getFluid(2000L), ELEMENT.getInstance().RUTHENIUM.getFluidStack(288), 0, 6000, 8000);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(19), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedCooperite", 8), ELEMENT.getInstance().CARBON.getDust(32)}, Materials.SulfuricAcid.getFluid(8000L), ELEMENT.getInstance().RUTHENIUM.getFluidStack(144), 0, 6000, 8000);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(20), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedScheelite", 8), ELEMENT.getInstance().CARBON.getDust(32)}, Materials.SulfuricAcid.getFluid(10000L), ELEMENT.getInstance().RHENIUM.getFluidStack(144), 0, 6000, 4000);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(20), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedMolybdenite", 8), ELEMENT.getInstance().CARBON.getDust(32)}, Materials.SulfuricAcid.getFluid(7500L), ELEMENT.getInstance().RHENIUM.getFluidStack(144), 0, 6000, 4000);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(20), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedMolybdenum", 8), ELEMENT.getInstance().CARBON.getDust(32)}, Materials.SulfuricAcid.getFluid(5000L), ELEMENT.getInstance().RHENIUM.getFluidStack(288), 0, 6000, 4000);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(21), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedZinc", 3), ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedPyrite", 4), ELEMENT.getInstance().CARBON.getDust(16)}, Materials.SulfuricAcid.getFluid(1250L), ELEMENT.getInstance().THALLIUM.getFluidStack(288), new ItemStack[0], new int[]{0}, 1500, 8000, 3700, false);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(21), MISC_MATERIALS.STRONTIUM_OXIDE.getDust(8), ELEMENT.getInstance().ALUMINIUM.getDust(8)}, (FluidStack)null, ELEMENT.getInstance().OXYGEN.getFluidStack(8000), new ItemStack[]{ELEMENT.getInstance().ALUMINIUM.getIngot(8), ELEMENT.getInstance().STRONTIUM.getIngot(8)}, new int[]{10000, 10000}, 2400, 1920);
        CORE.RA.addBlastSmelterRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(4), ItemUtils.getItemStackOfAmountFromOreDict("dustNitinol60", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustOsmium", 6), ItemUtils.getItemStackOfAmountFromOreDict("dustRuthenium", 6), ItemUtils.getItemStackOfAmountFromOreDict("dustThallium", 3)}, GT_Values.NF, ALLOY.BOTMIUM.getFluidStack(2304), 0, 2400, 491520);
    }

    private static void fluidcannerRecipes() {
        CORE.RA.addFluidCannerRecipe(ItemUtils.getSimpleStack(Items.field_151069_bo), ItemUtils.getSimpleStack(ModItems.itemSulfuricPotion), FluidUtils.getFluidStack("sulfuricacid", 250), null);
        CORE.RA.addFluidCannerRecipe(ItemUtils.getSimpleStack(ModItems.itemSulfuricPotion), ItemUtils.getSimpleStack(Items.field_151069_bo), null, FluidUtils.getFluidStack("sulfuricacid", 250));
        boolean addedGtExtraction = false;
        CORE.RA.addFluidCannerRecipe(ItemUtils.getSimpleStack(Items.field_151069_bo), ItemUtils.getSimpleStack(ModItems.itemHydrofluoricPotion), FluidUtils.getFluidStack("hydrofluoricacid_gt5u", 250), null);
        addedGtExtraction = CORE.RA.addFluidCannerRecipe(ItemUtils.getSimpleStack(ModItems.itemHydrofluoricPotion), ItemUtils.getSimpleStack(Items.field_151069_bo), null, FluidUtils.getFluidStack("hydrofluoricacid_gt5u", 250));
        CORE.RA.addFluidCannerRecipe(ItemUtils.getSimpleStack(Items.field_151069_bo), ItemUtils.getSimpleStack(ModItems.itemHydrofluoricPotion), FluidUtils.getFluidStack("hydrofluoricacid", 125), null);
        if (!addedGtExtraction) {
            CORE.RA.addFluidCannerRecipe(ItemUtils.getSimpleStack(ModItems.itemHydrofluoricPotion), ItemUtils.getSimpleStack(Items.field_151069_bo), null, FluidUtils.getFluidStack("hydrofluoricacid", 125));
        }
        CORE.RA.addFluidExtractionRecipe(ItemUtils.getItemStackOfAmountFromOreDict("dustCryotheum", 1), FluidUtils.getFluidStack("cryotheum", 250), 200, 240);
        CORE.RA.addFluidExtractionRecipe(ItemUtils.getSimpleStack(Items.field_151079_bi), FluidUtils.getFluidStack("ender", 250), 100, 30);
        CORE.RA.addFluidExtractionRecipe(ItemUtils.getItemStackOfAmountFromOreDict("dustPyrotheum", 1), FluidUtils.getFluidStack("pyrotheum", 250), 200, 240);
    }

    private static void dehydratorRecipes() {
        Logger.INFO("Loading Recipes for Chemical Dehydrator.");
        ItemStack cropGrape = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cropGrape", 1);
        ItemStack foodRaisins = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("foodRaisins", 1);
        if (cropGrape != null && foodRaisins != null) {
            CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedBioCircuit(20), cropGrape}, null, null, new ItemStack[]{foodRaisins}, new int[]{10000}, 10, 2);
        }
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedBioCircuit(21)}, FluidUtils.getFluidStack("fluid.sludge", 1000), FluidUtils.getFluidStack("nitricacid", 10), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustTinyIron", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyCopper", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyTin", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyNickel", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyCobalt", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyAluminium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinySilver", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyGold", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyIridium", 1)}, new int[]{10, 5, 5, 4, 4, 3, 2, 2, 1}, 40, 500);
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(18), CI.emptyCells(3)}, FluidUtils.getFluidStack("fluid.ethylbenzene", 1000), null, new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("cellStyrene", 1), ItemUtils.getItemStackOfAmountFromOreDict("cellHydrogen", 2)}, new int[]{10000, 10000}, 60, 30);
        if (Mods.PamsHarvestCraft.isModLoaded() && Mods.Backpack.isModLoaded()) {
            ItemStack aLeather1 = ItemUtils.getCorrectStacktype("harvestcraft:hardenedleatherItem", 1);
            ItemStack aLeather2 = ItemUtils.getCorrectStacktype("Backpack:tannedLeather", 1);
            CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(18), aLeather1}, FluidUtils.getFluidStack("fluid.ethylbenzene", 1000), null, new ItemStack[]{aLeather2}, new int[]{10000}, 100, 180);
        }
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(18), CI.emptyCells(1)}, FluidUtils.getFluidStack("aceticacid", 2000), MISC_MATERIALS.ACETIC_ANHYDRIDE.getFluidStack(1000), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("cellWater", 1)}, new int[]{10000}, 600, 480);
    }

    private static void largeChemReactorRecipes() {
        CORE.RA.addMultiblockChemicalRecipe(new ItemStack[]{CI.getNumberedCircuit(24)}, new FluidStack[]{FluidUtils.getFluidStack("fluid.ethylbenzene", 1000)}, new FluidStack[]{MaterialUtils.getMaterial("Styrene").getFluid(1000L), Materials.Hydrogen.getGas(2000L)}, null, 30, 30);
        CORE.RA.addMultiblockChemicalRecipe(new ItemStack[]{CI.getNumberedCircuit(24)}, new FluidStack[]{MaterialUtils.getMaterial("Ethylene").getGas(500L), MaterialUtils.getMaterial("Benzene").getFluid(500L)}, new FluidStack[]{MaterialUtils.getMaterial("Styrene").getFluid(500L), Materials.Hydrogen.getGas(1000L)}, null, 240, 120);
    }

    private static void fissionFuelRecipes() {
    }

    private static void assemblerRecipes() {
        RECIPES_GREGTECH.addAR(ItemUtils.getItemStackOfAmountFromOreDict("plateVanadium", 32), ItemUtils.getItemStackOfAmountFromOreDict("frameGtVanadiumSteel", 8), FluidUtils.getFluidStack("oxygen", 8000), ItemUtils.simpleMetaStack(ModItems.itemHalfCompleteCasings, 0, 4), 16, 60);
        RECIPES_GREGTECH.addAR(ItemUtils.simpleMetaStack(ModItems.itemHalfCompleteCasings, 0, 2), ItemUtils.getItemStackOfAmountFromOreDict("plateVanadiumGallium", 8), FluidUtils.getFluidStack("molten.tantalum", 576), ItemUtils.simpleMetaStack(ModItems.itemHalfCompleteCasings, 1, 8), 32, 120);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{ItemUtils.simpleMetaStack(ModItems.itemHalfCompleteCasings, 1, 1), ItemUtils.getItemStackOfAmountFromOreDict("plateDenseLead", 4), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(3), 4), ItemUtils.getItemStackOfAmountFromOreDict("wireGt01SuperconductorHV", 2)}, FluidUtils.getFluidStack("oxygen", 16000), ItemUtils.getSimpleStack(GregtechItemList.Casing_Vanadium_Redox.get(1L, new Object[0]), 1), 64, 240);
        ItemStack T1 = GregtechItemList.Casing_Vanadium_Redox.get(1L, new Object[0]);
        ItemStack T2 = GregtechItemList.Casing_Vanadium_Redox_IV.get(1L, new Object[0]);
        ItemStack T3 = GregtechItemList.Casing_Vanadium_Redox_LuV.get(1L, new Object[0]);
        ItemStack T4 = GregtechItemList.Casing_Vanadium_Redox_ZPM.get(1L, new Object[0]);
        ItemStack T5 = GregtechItemList.Casing_Vanadium_Redox_UV.get(1L, new Object[0]);
        ItemStack T6 = GregtechItemList.Casing_Vanadium_Redox_MAX.get(1L, new Object[0]);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{T1, ItemUtils.getItemStackOfAmountFromOreDict("plateDenseTitanium", 4), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(4), 4), ItemUtils.getItemStackOfAmountFromOreDict("wireGt01SuperconductorEV", 2)}, FluidUtils.getFluidStack("nitrogen", 16000), T2, 120, 2000);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{T2, ItemUtils.getItemStackOfAmountFromOreDict("plateDenseTungstenSteel", 4), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(5), 4), ItemUtils.getItemStackOfAmountFromOreDict("wireGt01SuperconductorIV", 2)}, FluidUtils.getFluidStack("helium", 8000), T3, 250, 8000);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{T3, ItemUtils.getItemStackOfAmountFromOreDict("plateAlloyIridium", 16), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(6), 4), ItemUtils.getItemStackOfAmountFromOreDict("wireGt01SuperconductorLuV", 2)}, FluidUtils.getFluidStack("argon", 4000), T4, 500, 32000);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{T4, ItemUtils.getItemStackOfAmountFromOreDict("plateDenseNaquadah", 4), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(7), 4), ItemUtils.getItemStackOfAmountFromOreDict("wireGt01SuperconductorZPM", 2)}, FluidUtils.getFluidStack("radon", 4000), T5, 1000, 128000);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{T5, ItemUtils.getItemStackOfAmountFromOreDict("plateDenseAmericium", 4), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(8), 4), ItemUtils.getItemStackOfAmountFromOreDict("wireGt01SuperconductorUV", 2)}, FluidUtils.getFluidStack("krypton", 500), T6, 2000, 512000);
        RECIPES_GREGTECH.addAR(ItemUtils.getItemStackOfAmountFromOreDict("dustClay", 32), GregtechItemList.Bomb_Cast_Mold.get(0L, new Object[0]), FluidUtils.getWater(4000), GregtechItemList.Bomb_Cast.get(4L, new Object[0]), 30, 120);
        RECIPES_GREGTECH.addAR(ItemUtils.getSimpleStack(Items.field_151137_ax, 32), ItemUtils.getSimpleStack(ModItems.itemRope, 16), Materials.Glue.getFluid(500L), ItemUtils.getSimpleStack(ModItems.itemDetCable, 24), 30, 120);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{ItemUtils.getSimpleStack(ModItems.itemRope, 6)}, null, ItemUtils.getSimpleStack(ModBlocks.blockNet, 2), 20, 8);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{ItemUtils.getSimpleStack(CI.explosiveITNT, 2), ItemUtils.getSimpleStack(CI.explosiveTNT, 4), ELEMENT.getInstance().SULFUR.getDust(2), ELEMENT.getInstance().IRON.getFrameBox(1)}, null, ItemUtils.getSimpleStack(ModBlocks.blockMiningExplosive, 3), 100, 60);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{ItemUtils.getSimpleStack(Items.field_151156_bN), ItemUtils.getItemStackOfAmountFromOreDict("plateTungstenSteel", 8), ItemUtils.getItemStackOfAmountFromOreDict("stickBlackSteel", 8)}, null, ItemUtils.getSimpleStack(ModBlocks.blockWitherGuard, 64), 600, 500);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{CI.fluidRegulator_LV, CI.electricMotor_LV, CI.getTieredComponent(OrePrefixes.bolt, 1, 8), ItemUtils.getItemStackOfAmountFromOreDict("ringBrass", 1), ItemUtils.getItemStackOfAmountFromOreDict("stickBrass", 1), ItemUtils.getItemStackOfAmountFromOreDict("plateSteel", 2)}, null, ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 1, 1), 200, 30);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{CI.fluidRegulator_MV, CI.electricMotor_MV, CI.getTieredComponent(OrePrefixes.bolt, 2, 8), ItemUtils.getItemStackOfAmountFromOreDict("ringInvar", 1), ItemUtils.getItemStackOfAmountFromOreDict("stickInvar", 1), ItemUtils.getItemStackOfAmountFromOreDict("plateAluminium", 2)}, null, ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 2, 1), 400, 120);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{CI.fluidRegulator_HV, CI.electricMotor_HV, CI.getTieredComponent(OrePrefixes.bolt, 3, 8), ItemUtils.getItemStackOfAmountFromOreDict("ringChrome", 1), ItemUtils.getItemStackOfAmountFromOreDict("stickChrome", 1), ItemUtils.getItemStackOfAmountFromOreDict("plateStainlessSteel", 2)}, null, ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 3, 1), 600, 480);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{CI.fluidRegulator_EV, CI.electricMotor_EV, CI.getTieredComponent(OrePrefixes.bolt, 4, 8), ItemUtils.getItemStackOfAmountFromOreDict("ringTitanium", 1), ItemUtils.getItemStackOfAmountFromOreDict("stickTitanium", 1), ItemUtils.getItemStackOfAmountFromOreDict("plateTungstenSteel", 2)}, null, ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 4, 1), 800, 1960);
        GT_Values.RA.addAssemblerRecipe(ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 1, 1), CI.getNumberedCircuit(20), ItemUtils.simpleMetaStack(ModItems.toolGregtechPump, 1000, 1), 30, 30);
        GT_Values.RA.addAssemblerRecipe(ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 2, 1), CI.getNumberedCircuit(20), ItemUtils.simpleMetaStack(ModItems.toolGregtechPump, 1001, 1), 120, 120);
        GT_Values.RA.addAssemblerRecipe(ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 3, 1), CI.getNumberedCircuit(20), ItemUtils.simpleMetaStack(ModItems.toolGregtechPump, 1002, 1), 480, 480);
        GT_Values.RA.addAssemblerRecipe(ItemUtils.simpleMetaStack(ModItems.itemGenericToken, 4, 1), CI.getNumberedCircuit(20), ItemUtils.simpleMetaStack(ModItems.toolGregtechPump, 1003, 1), 1820, 1820);
        ItemStack[] aPackBatteries = new ItemStack[]{ItemList.Battery_RE_LV_Lithium.get(4L, new Object[0]), ItemList.Battery_RE_MV_Lithium.get(4L, new Object[0]), ItemList.Battery_RE_HV_Lithium.get(4L, new Object[0]), GregtechItemList.Battery_RE_EV_Lithium.get(4L, new Object[0]), ItemList.Energy_LapotronicOrb.get(4L, new Object[0])};
        ItemStack[] aPackPlates = new ItemStack[]{CI.getPlate(1, 8), CI.getPlate(2, 8), CI.getPlate(3, 8), CI.getPlate(4, 8), CI.getPlate(5, 8)};
        ItemStack[] aPackWire = new ItemStack[]{CI.getTieredComponent(OrePrefixes.wireGt02, 1, 6), CI.getTieredComponent(OrePrefixes.wireGt04, 2, 6), CI.getTieredComponent(OrePrefixes.wireGt08, 3, 6), CI.getTieredComponent(OrePrefixes.wireGt12, 4, 6), CI.getTieredComponent(OrePrefixes.wireGt16, 5, 6)};
        ItemStack[] aPackCircuit = new ItemStack[]{CI.getTieredComponent(OrePrefixes.circuit, 1, 4), CI.getTieredComponent(OrePrefixes.circuit, 2, 4), CI.getTieredComponent(OrePrefixes.circuit, 3, 4), CI.getTieredComponent(OrePrefixes.circuit, 4, 4), CI.getTieredComponent(OrePrefixes.circuit, 5, 4)};
        ItemStack[] aPackRing = new ItemStack[]{CI.getTieredComponent(OrePrefixes.ring, 1, 12), CI.getTieredComponent(OrePrefixes.ring, 2, 12), CI.getTieredComponent(OrePrefixes.ring, 3, 12), CI.getTieredComponent(OrePrefixes.ring, 4, 12), CI.getTieredComponent(OrePrefixes.ring, 5, 12)};
        ItemStack[] aPackOutput = new ItemStack[]{ItemUtils.getSimpleStack(ModItems.itemChargePack_Low_1), ItemUtils.getSimpleStack(ModItems.itemChargePack_Low_2), ItemUtils.getSimpleStack(ModItems.itemChargePack_Low_3), ItemUtils.getSimpleStack(ModItems.itemChargePack_Low_4), ItemUtils.getSimpleStack(ModItems.itemChargePack_Low_5)};
        for (int i = 1; i < 6; ++i) {
            int aAS = i - 1;
            CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{aPackPlates[aAS], aPackRing[aAS], aPackWire[aAS], aPackCircuit[aAS], aPackBatteries[aAS], CI.getSensor(i, 4)}, CI.getTieredFluid(i, 576), aPackOutput[aAS], 600 * i, (int)GT_Values.V[i]);
        }
        if (Mods.Baubles.isModLoaded()) {
            CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(17), ItemUtils.getItemStackOfAmountFromOreDict("plateTrinium", 64), CI.getSensor(6, 6), CI.getBolt(7, 64), ItemUtils.getItemStackOfAmountFromOreDict("wireFinePlatinum", 64), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(7), 12)}, CI.getAlternativeTieredFluid(7, 4608), ItemDummyResearch.getResearchStack(ItemDummyResearch.ASSEMBLY_LINE_RESEARCH.RESEARCH_8_TURBINE_AUTOMATION, 1), 6000, (int)GT_Values.V[6]);
            CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(17), ItemUtils.getSimpleStack(ModItems.itemCircuitLFTR, 4), CI.getFieldGenerator(6, 16), ItemUtils.getItemStackOfAmountFromOreDict("wireFinePalladium", 32), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(6), 12)}, CI.getAlternativeTieredFluid(7, 4608), ItemDummyResearch.getResearchStack(ItemDummyResearch.ASSEMBLY_LINE_RESEARCH.RESEARCH_9_CLOAKING, 1), 12000, (int)GT_Values.V[7]);
            CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{ItemUtils.getGregtechCircuit(19), ItemUtils.getSimpleStack(ModItems.itemRope, 32), ItemUtils.getItemStackOfAmountFromOreDict("gearGtSmallWroughtIron", 8), ItemUtils.getItemStackOfAmountFromOreDict("wireFineCopper", 32), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(1), 2)}, FluidUtils.getFluidStack("molten.rubber", 2000), ItemUtils.getSimpleStack(ModItems.itemPersonalFireProofDevice), 6000, 30);
        }
    }

    private static boolean addAR(ItemStack inputA, ItemStack inputB, FluidStack inputFluidA, ItemStack outputA, int seconds, int voltage) {
        return GT_Values.RA.addAssemblerRecipe(inputA, inputB, inputFluidA, outputA, seconds * 20, voltage);
    }

    private static void distilleryRecipes() {
        Logger.INFO("Registering Distillery/Distillation Tower Recipes.");
        GT_Values.RA.addDistilleryRecipe(ItemList.Circuit_Integrated.getWithDamage(0L, 4L, new Object[0]), FluidUtils.getFluidStack("air", 1000), FluidUtils.getFluidStack("helium", 1), 400, 30, false);
        GT_Values.RA.addDistillationTowerRecipe(FluidUtils.getFluidStack("air", 20000), FluidUtils.getFluidStackArray("helium", 25), ItemUtils.getSimpleStack(ModItems.itemHydrogenBlob, 1), 200, 60);
        FluidStack[] apatiteOutput = new FluidStack[]{FluidUtils.getFluidStack("sulfurousacid", 3800), FluidUtils.getFluidStack("hydrogenchloride", 1000), FluidUtils.getFluidStack("hydrofluoricacid", 400)};
        GT_Values.RA.addDistillationTowerRecipe(FluidUtils.getFluidStack("sulfuricapatite", 5200), apatiteOutput, null, 900, 120);
        FluidStack[] sulfurousacidOutput = new FluidStack[]{FluidUtils.getFluidStack("sulfurdioxide", 500), FluidUtils.getFluidStack("water", 500)};
        GT_Values.RA.addDistillationTowerRecipe(FluidUtils.getFluidStack("sulfurousacid", 1000), sulfurousacidOutput, null, 200, 60);
    }

    private static void addFuels() {
        Logger.INFO("Registering New Fuels.");
        HotFuel.addNewHotFuel(FluidUtils.getLava(83), FluidUtils.getPahoehoeLava(83), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("nuggetCopper", 1), ItemUtils.getItemStackOfAmountFromOreDict("nuggetTin", 1), ItemUtils.getItemStackOfAmountFromOreDict("nuggetGold", 1), ItemUtils.getItemStackOfAmountFromOreDict("nuggetSilver", 1), ItemUtils.getItemStackOfAmountFromOreDict("nuggetTantalum", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallTungstate", 1), ItemUtils.getSimpleStack(Blocks.field_150343_Z)}, new int[]{2000, 1000, 250, 250, 250, 250, 500}, 0);
        HotFuel.addNewHotFuel(FluidUtils.getPahoehoeLava(83), GT_Values.NF, new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("nuggetBronze", 1), ItemUtils.getItemStackOfAmountFromOreDict("nuggetElectrum", 1), ItemUtils.getItemStackOfAmountFromOreDict("nuggetTantalum", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallTungstate", 1), ItemUtils.getSimpleStack(Blocks.field_150343_Z)}, new int[]{750, 250, 250, 250, 1850}, 0);
        HotFuel.addNewHotFuel(MISC_MATERIALS.SOLAR_SALT_HOT.getFluidStack(100), MISC_MATERIALS.SOLAR_SALT_COLD.getFluidStack(100), FluidUtils.getSuperHeatedSteam(100000), 0);
        ThermalFuel.addSteamTurbineFuel(FluidUtils.getFluidStack("steam", 1024));
        GT_Values.RA.addFuel(ItemUtils.getSimpleStack(Items.field_151129_at), null, 32, 2);
        GT_Values.RA.addFuel(ItemUtils.getIC2Cell(2), null, 32, 2);
        GT_Values.RA.addFuel(ItemUtils.getIC2Cell(11), null, 24, 2);
    }

    private static void extractorRecipes() {
        Logger.INFO("Registering Extractor Recipes.");
        GT_ModHandler.addExtractionRecipe((ItemStack)GregtechItemList.Battery_RE_EV_Sodium.get(1L, new Object[0]), (ItemStack)ItemList.Battery_Hull_HV.get(4L, new Object[0]));
        GT_ModHandler.addExtractionRecipe((ItemStack)GregtechItemList.Battery_RE_EV_Cadmium.get(1L, new Object[0]), (ItemStack)ItemList.Battery_Hull_HV.get(4L, new Object[0]));
        GT_ModHandler.addExtractionRecipe((ItemStack)GregtechItemList.Battery_RE_EV_Lithium.get(1L, new Object[0]), (ItemStack)ItemList.Battery_Hull_HV.get(4L, new Object[0]));
    }

    private static void fluidExtractorRecipes() {
    }

    private static void chemicalBathRecipes() {
    }

    private static void centrifugeRecipes() {
        GT_Values.RA.addCentrifugeRecipe(CI.getNumberedAdvancedCircuit(2), MISC_MATERIALS.SOLAR_SALT_COLD.getCell(5), null, null, MISC_MATERIALS.SODIUM_NITRATE.getDust(15), MISC_MATERIALS.POTASSIUM_NITRATE.getDust(10), CI.emptyCells(5), null, null, null, null, 600, 120);
    }

    private static void mixerRecipes() {
        GT_Values.RA.addMixerRecipe(CI.getNumberedAdvancedCircuit(2), CI.emptyCells(5), MISC_MATERIALS.SODIUM_NITRATE.getDust(15), MISC_MATERIALS.POTASSIUM_NITRATE.getDust(10), null, null, MISC_MATERIALS.SOLAR_SALT_COLD.getCell(5), 200, 120);
        GT_Values.RA.addMixerRecipe(CI.getNumberedAdvancedCircuit(2), Materials.Titanium.getDust(9), Materials.Carbon.getDust(9), Materials.Potassium.getDust(9), Materials.Lithium.getDust(9), Materials.Sulfur.getDust(9), Materials.Hydrogen.getFluid(5000L), null, ALLOY.LEAGRISIUM.getDust(50), 1200, (int)TierEU.RECIPE_EV);
        GT_Values.RA.addMixerRecipe(CI.getNumberedAdvancedCircuit(2), Materials.Steel.getDust(16), Materials.Molybdenum.getDust(1), Materials.Titanium.getDust(1), Materials.Nickel.getDust(4), Materials.Cobalt.getDust(2), GT_Values.NF, null, ALLOY.MARAGING250.getDust(24), 1200, (int)TierEU.RECIPE_EV);
    }

    private static void chemicalReactorRecipes() {
        GT_Values.RA.addChemicalRecipe(ItemUtils.getSimpleStack(ModItems.itemBombCasing, 4), ItemUtils.getSimpleStack(RocketFuels.Ammonium_Nitrate_Dust, 8), Materials.Fuel.getFluid(1000L), null, ItemUtils.getSimpleStack(ModItems.itemBombUnf, 4), 6000);
        GT_Values.RA.addChemicalRecipe(ItemUtils.getSimpleStack(ModItems.itemBombUnf, 4), ItemUtils.getSimpleStack(ModItems.itemDetCable, 4), FluidUtils.getFluidStack(RocketFuels.Kerosene, 100), null, ItemUtils.getSimpleStack(ModItems.itemBomb, 4), 200);
        GT_Values.RA.addChemicalRecipe(CI.getNumberedAdvancedCircuit(21), ItemUtils.getItemStackOfAmountFromOreDict("dustApatite", 32), FluidUtils.getFluidStack("sulfuricacid", 4000), FluidUtils.getFluidStack("sulfuricapatite", 8000), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallSulfur", 8), 400);
        GT_Values.RA.addChemicalRecipe(ItemUtils.getSimpleStack(GenericChem.mPotassiumHydroxide, 3), CI.getNumberedAdvancedCircuit(1), Materials.NitricAcid.getFluid(1000L), Materials.Water.getFluid(1000L), MISC_MATERIALS.POTASSIUM_NITRATE.getDust(5), 100, 30);
        GT_Values.RA.addChemicalRecipe(ItemUtils.getSimpleStack(AgriculturalChem.mSodiumCarbonate, 6), CI.getNumberedAdvancedCircuit(1), Materials.NitricAcid.getFluid(2000L), Materials.CarbonDioxide.getGas(1000L), MISC_MATERIALS.SODIUM_NITRATE.getDust(10), 100, 30);
    }

    private static void blastFurnaceRecipes() {
        GT_Values.RA.addBlastRecipe(CI.getNumberedCircuit(22), ALLOY.SILICON_CARBIDE.getDust(16), ELEMENT.getInstance().NITROGEN.getFluidStack(4000), GT_Values.NF, ItemUtils.getItemStackOfAmountFromOreDict("dustGraphite", 8), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallSilicon", 8), 1200, MaterialUtils.getVoltageForTier(5), 4500);
        GT_Values.RA.addBlastRecipe(GregtechItemList.Bomb_Cast.get(4L, new Object[0]), ALLOY.STEEL.getDust(16), ELEMENT.getInstance().OXYGEN.getFluidStack(2000), GT_Values.NF, GregtechItemList.Bomb_Cast_Molten.get(4L, new Object[0]), null, 4800, MaterialUtils.getVoltageForTier(3), 2800);
        if (ModItems.itemHotTitaniumIngot != null) {
            GT_Values.RA.addBlastRecipe(ItemUtils.getItemStackOfAmountFromOreDict("ingotTitanium", 1), CI.getNumberedCircuit(16), GT_Values.NF, GT_Values.NF, ItemUtils.getItemStackOfAmountFromOreDict("ingotHotTitanium", 1), null, 200, 500, (int)Materials.Titanium.mBlastFurnaceTemp);
        }
    }

    private static void autoclaveRecipes() {
    }

    private static void benderRecipes() {
        if (CORE.ConfigSwitches.enableMultiblock_PowerSubstation) {
            GT_Values.RA.addBenderRecipe(ItemUtils.getItemStackOfAmountFromOreDict("ingotVanadium", 1), ItemUtils.getItemStackOfAmountFromOreDict("plateVanadium", 1), 8, 16);
        }
    }

    private static void compressorRecipes() {
        GT_ModHandler.addCompressionRecipe((ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("dustClay", 1), (ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("plateClay", 1));
        GT_ModHandler.addCompressionRecipe((ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("dustMeatRaw", 1), (ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("plateMeatRaw", 1));
        GT_ModHandler.addCompressionRecipe((ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("dustMeatRaw", 9), (ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("blockMeatRaw", 1));
        CORE.RA.addCompressorRecipe(ItemList.FusionComputer_UV.get(9L, new Object[0]), GregtechItemList.Compressed_Fusion_Reactor.get(1L, new Object[0]), (int)GT_Values.V[7], (int)GT_Values.V[8]);
    }

    private static void macerationRecipes() {
        GT_ModHandler.addPulverisationRecipe((ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("blockMeatRaw", 1), (ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("dustMeatRaw", 9));
        GT_ModHandler.addPulverisationRecipe((ItemStack)GregtechItemList.Bomb_Cast_Broken.get(1L, new Object[0]), (ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("dustClay", 3));
        if (ItemUtils.simpleMetaStack("chisel:limestone", 0, 1) != null) {
            GT_ModHandler.addPulverisationRecipe((ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("limestone", 1), (ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("dustCalcite", 4));
        }
    }

    private static void cyclotronRecipes() {
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(1), FluidUtils.getFluidStack("molten.bismuth", 1), new ItemStack[]{GregtechItemList.Pellet_RTG_PO210.get(1L, new Object[0])}, null, new int[]{100}, 600000, 8160, 10000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(1), FluidUtils.getFluidStack("molten.americium", 1), new ItemStack[]{GregtechItemList.Pellet_RTG_AM241.get(4L, new Object[0])}, null, new int[]{2500}, 600000, 4080, 10000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(1), FluidUtils.getFluidStack("molten.uranium235", 10), new ItemStack[]{GregtechItemList.Pellet_RTG_SR90.get(1L, new Object[0])}, null, new int[]{570}, 600000, 4080, 10000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(1), FluidUtils.getFluidStack("molten.uranium233", 10), new ItemStack[]{GregtechItemList.Pellet_RTG_SR90.get(1L, new Object[0])}, null, new int[]{660}, 600000, 4080, 10000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(1), FluidUtils.getFluidStack("molten.plutonium239", 10), new ItemStack[]{GregtechItemList.Pellet_RTG_SR90.get(1L, new Object[0])}, null, new int[]{220}, 600000, 4080, 10000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(1), FluidUtils.getFluidStack("molten.plutonium238", 1), new ItemStack[]{GregtechItemList.Pellet_RTG_PU238.get(2L, new Object[0])}, null, new int[]{780}, 600000, 4080, 10000);
        CORE.RA.addCyclotronRecipe(new ItemStack[]{ELEMENT.getInstance().URANIUM238.getDust(1)}, FluidUtils.getFluidStack("deuterium", 400), new ItemStack[]{ItemUtils.getSimpleStack(ModItems.dustNeptunium238)}, null, new int[]{500}, 100, 2000, 10000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(3), FluidUtils.getFluidStack("plasma.hydrogen", 100), new ItemStack[]{Particle.getBaseParticle(Particle.UP), Particle.getBaseParticle(Particle.DOWN), Particle.getBaseParticle(Particle.CHARM), Particle.getBaseParticle(Particle.STRANGE), Particle.getBaseParticle(Particle.TOP), Particle.getBaseParticle(Particle.BOTTOM)}, null, new int[]{50, 50, 50, 50, 50, 50}, 54000, MaterialUtils.getVoltageForTier(7), 15000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(6), FluidUtils.getFluidStack("plasma.helium", 1500), new ItemStack[]{Particle.getBaseParticle(Particle.ELECTRON), Particle.getBaseParticle(Particle.MUON), Particle.getBaseParticle(Particle.TAU), Particle.getBaseParticle(Particle.ELECTRON_NEUTRINO), Particle.getBaseParticle(Particle.MUON_NEUTRINO), Particle.getBaseParticle(Particle.TAU_NEUTRINO)}, null, new int[]{600, 40, 20, 15, 10, 5}, 48000, MaterialUtils.getVoltageForTier(7), 15000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(9), FluidUtils.getFluidStack("plasma.helium", 1500), new ItemStack[]{Particle.getBaseParticle(Particle.GLUON), Particle.getBaseParticle(Particle.PHOTON), Particle.getBaseParticle(Particle.Z_BOSON), Particle.getBaseParticle(Particle.W_BOSON), Particle.getBaseParticle(Particle.HIGGS_BOSON)}, null, new int[]{160, 260, 150, 150, 1}, 36000, MaterialUtils.getVoltageForTier(7), 15000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(12), FluidUtils.getFluidStack("plasma.beryllium", 2500), new ItemStack[]{Particle.getBaseParticle(Particle.GRAVITON), Particle.getBaseParticle(Particle.ETA_MESON), Particle.getBaseParticle(Particle.PION), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.NEUTRON), Particle.getBaseParticle(Particle.LAMBDA), Particle.getBaseParticle(Particle.OMEGA), Particle.getBaseParticle(Particle.HIGGS_BOSON)}, null, new int[]{10, 20, 20, 10, 10, 5, 5, 2}, 134368, MaterialUtils.getVoltageForTier(8), 15000);
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(15), FluidUtils.getFluidStack("plasma.hydrogen", 50), new ItemStack[]{Particle.getBaseParticle(Particle.GRAVITON), Particle.getBaseParticle(Particle.UNKNOWN)}, null, new int[]{15, 100}, 1800, MaterialUtils.getVoltageForTier(6), 20000);
        FluidStack aPlasma = Materials.Duranium.getMolten(40L);
        FluidStack aPlasma_NULL = Materials._NULL.getPlasma(1L);
        if (aPlasma == null || aPlasma.isFluidEqual(aPlasma_NULL)) {
            aPlasma = Materials.Americium.getMolten(20L);
        }
        CORE.RA.addCyclotronRecipe(new ItemStack[]{CI.getNumberedCircuit(24), Particle.getBaseParticle(Particle.UNKNOWN)}, aPlasma, new ItemStack[]{GregtechItemList.Laser_Lens_Special.get(1L, new Object[0])}, null, new int[]{100}, 500, MaterialUtils.getVoltageForTier(8), 10000);
        int IonCount = 2;
        int tenCountA = 2;
        int tenCountB = 0;
        for (String y : IonParticles.MetaToNameMap.values()) {
            FluidStack aPlasma3;
            if (y.toLowerCase().contains("hydrogen")) continue;
            FluidStack aPlasma2 = FluidUtils.getFluidStack("plasma." + y.toLowerCase(), 2);
            Materials aTestMat = MaterialUtils.getMaterial(y);
            FluidStack fluidStack = aPlasma3 = aTestMat != null ? aTestMat.getPlasma(2L) : aPlasma2;
            if (aPlasma2 != null && !aPlasma2.isFluidEqual(aPlasma_NULL) || aPlasma3 != null && !aPlasma3.isFluidEqual(aPlasma_NULL)) {
                CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(1 + (tenCountA - 1)), aPlasma2 != null ? aPlasma2 : aPlasma3, new ItemStack[]{Particle.getIon(y, 1), Particle.getIon(y, 2), Particle.getIon(y, 3), Particle.getIon(y, -1), Particle.getIon(y, -2), Particle.getIon(y, -3), Particle.getIon(y, 1), Particle.getIon(y, 2), Particle.getIon(y, -1)}, null, new int[]{275, 250, 225, 275, 250, 225, 275, 250, 275}, 400 * IonCount++ * tenCountA, MaterialUtils.getVoltageForTier(7), 30000 * tenCountA);
            } else {
                Logger.INFO("Plasma for " + y + " does not exist, please report this to Alkalus.");
            }
            if (tenCountB == 12) {
                tenCountB = 0;
                ++tenCountA;
                continue;
            }
            ++tenCountB;
        }
        CORE.RA.addCyclotronRecipe(CI.getNumberedCircuit(24), FluidUtils.getWildcardFluidStack("hydrogen", 1000), new ItemStack[]{Particle.getIon("Hydrogen", 1), Particle.getIon("Hydrogen", 2), Particle.getIon("Hydrogen", 3), Particle.getIon("Hydrogen", 1), Particle.getIon("Hydrogen", 2), Particle.getIon("Hydrogen", 3), Particle.getIon("Hydrogen", -1), Particle.getIon("Hydrogen", -2), Particle.getIon("Hydrogen", -3)}, null, new int[]{500, 500, 500, 500, 500, 500, 500, 500, 500}, 400, MaterialUtils.getVoltageForTier(6), 2500);
        CORE.RA.addCyclotronRecipe(new ItemStack[]{Particle.getIon("Hydrogen", 0), ItemUtils.getItemStackOfAmountFromOreDict("cellHydrogen", 1)}, null, new ItemStack[]{Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.NEUTRON), Particle.getBaseParticle(Particle.ELECTRON), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), CI.emptyCells(1)}, FluidUtils.getFluidStack("plasma.hydrogen", 100), new int[]{1250, 1250, 1250, 750, 750, 750, 10000}, 2400, MaterialUtils.getVoltageForTier(6), 15000);
        CORE.RA.addCyclotronRecipe(new ItemStack[]{CI.getNumberedCircuit(21), Particle.getIon("Hydrogen", 0)}, FluidUtils.getFluidStack("hydrogen", 1000), new ItemStack[]{Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.NEUTRON), Particle.getBaseParticle(Particle.ELECTRON), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN)}, FluidUtils.getFluidStack("plasma.hydrogen", 100), new int[]{1250, 1250, 1250, 750, 750, 750}, 2400, MaterialUtils.getVoltageForTier(6), 15000);
        CORE.RA.addCyclotronRecipe(new ItemStack[]{CI.getNumberedCircuit(20), Particle.getIon("Hydrogen", 0)}, FluidUtils.getWildcardFluidStack("hydrogen", 100), new ItemStack[]{Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON)}, null, new int[]{750, 750, 750, 750, 750, 750, 750, 750, 750}, 400, MaterialUtils.getVoltageForTier(6), 1500);
        CORE.RA.addCyclotronRecipe(new ItemStack[]{CI.getNumberedCircuit(22), Particle.getBaseParticle(Particle.UNKNOWN)}, FluidUtils.getWildcardFluidStack("hydrogen", 100), new ItemStack[]{Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON), Particle.getBaseParticle(Particle.PROTON)}, null, new int[]{375, 375, 375, 375, 375, 375, 375, 375, 375}, 400, MaterialUtils.getVoltageForTier(6), 1500);
        CORE.RA.addCyclotronRecipe(new ItemStack[]{ELEMENT.getInstance().PLUTONIUM238.getDust(1), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN), Particle.getBaseParticle(Particle.UNKNOWN)}, FluidUtils.getFluidStack(FluidUtils.getWildcardFluidStack("ender", 1000), 1000), new ItemStack[]{ORES.DEEP_EARTH_REACTOR_FUEL_DEPOSIT.getDust(1)}, null, new int[]{2500}, 18000, MaterialUtils.getVoltageForTier(7), 250);
    }

    private static void sifterRecipes() {
    }

    private static void electroMagneticSeperatorRecipes() {
    }

    private static void advancedMixerRecipes() {
    }
}

