/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.plugin.fixes.vanilla;

import gtPlusPlus.api.interfaces.IPlugin;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.plugin.fixes.interfaces.IBugFix;
import gtPlusPlus.plugin.fixes.vanilla.music.MusicTocker;
import gtPlusPlus.preloader.CORE_Preloader;
import java.util.Timer;
import java.util.TimerTask;

public class VanillaBackgroundMusicFix
implements IBugFix {
    private final IPlugin mParent;
    private final boolean enabled;
    private MusicTocker mFixInstance;

    public VanillaBackgroundMusicFix(IPlugin minstance) {
        this.mParent = minstance;
        if (CORE_Preloader.enableWatchdogBGM > 0 && Utils.isClient()) {
            this.mParent.log("[BGM] Registering BGM delay Fix.");
            this.enabled = true;
            this.mFixInstance = new MusicTocker(this.mParent);
        } else if (CORE_Preloader.enableWatchdogBGM > 0 && Utils.isServer()) {
            this.mParent.log("[BGM] Tried registering BGM delay Fix on Server, disabling.");
            this.enabled = false;
        } else {
            this.mParent.log("[BGM] Not registering BGM delay Fix.");
            this.enabled = false;
        }
    }

    @Override
    public boolean isFixValid() {
        return this.enabled;
    }

    public void manage() {
        if (CORE_Preloader.enableWatchdogBGM > 0 && Utils.isClient()) {
            ManageTask task = new ManageTask(this.mFixInstance);
            Timer timer = new Timer("BGM-WatchDog");
            long delay = 60000L;
            timer.scheduleAtFixedRate((TimerTask)task, delay, 5000L);
        }
    }

    private static class ManageTask
    extends TimerTask {
        private final MusicTocker A;

        public ManageTask(MusicTocker a) {
            this.A = a;
        }

        @Override
        public void run() {
            if (CORE_Preloader.enableWatchdogBGM > 0 && Utils.isClient() && !this.A.mVanillaManager) {
                this.A.run();
            }
        }
    }
}

