/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.util.GT_ModHandler;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.metatileentity.custom.power.GTPP_MTE_TieredMachineBlock;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_BasicBreaker
extends GTPP_MTE_TieredMachineBlock
implements IAddUIWidgets {
    public boolean mCharge = false;
    public boolean mDecharge = false;
    public int mBatteryCount = 0;
    public int mChargeableCount = 0;
    private long count = 0L;
    private long mStored = 0L;
    private long mMax = 0L;

    public GT_MetaTileEntity_BasicBreaker(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aSlotCount, aDescription, new ITexture[0]);
    }

    public GT_MetaTileEntity_BasicBreaker(String aName, int aTier, String aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_BasicBreaker(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aSlotCount, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        String[] desc = new String[6];
        byte tTier = this.mTier;
        desc[0] = "" + EnumChatFormatting.BOLD + "16 Fuse Slots";
        desc[1] = "Per each fuse, you may insert " + EnumChatFormatting.YELLOW + GT_Values.V[tTier] + EnumChatFormatting.GRAY + " EU/t";
        desc[2] = "However this " + EnumChatFormatting.ITALIC + EnumChatFormatting.RED + "MUST" + EnumChatFormatting.GRAY + " be in a single Amp";
        desc[3] = "This machine can accept upto a single amp of " + GT_Values.VN[Math.min(tTier + 2, 15)] + " as a result";
        desc[4] = "Breaker Loss: " + EnumChatFormatting.RED + "" + GT_Values.V[tTier] / 16L + EnumChatFormatting.GRAY + " EU/t";
        desc[5] = CORE.GT_Tooltip.get();
        return desc;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[2][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            rTextures[0][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], this.mInventory.length > 4 ? Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[Math.min(12, this.mTier)] : Textures.BlockIcons.OVERLAYS_ENERGY_IN[Math.min(12, this.mTier)]};
            rTextures[1][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], this.mInventory.length > 4 ? Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier] : Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[side == facing ? 1 : 0][aColorIndex + 1];
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_BasicBreaker(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mInventory.length);
    }

    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isElectric() {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isEnetOutput() {
        return true;
    }

    public boolean isInputFacing(ForgeDirection side) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 16L * 16L;
    }

    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 64L * 16L;
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier] * 16L;
    }

    public long maxEUOutput() {
        return GT_Values.V[this.mTier];
    }

    public long maxAmperesIn() {
        return 16L;
    }

    public long maxAmperesOut() {
        return 16L;
    }

    public int rechargerSlotStartIndex() {
        return 0;
    }

    public int dechargerSlotStartIndex() {
        return 0;
    }

    public int rechargerSlotCount() {
        return 0;
    }

    public int dechargerSlotCount() {
        return 0;
    }

    public int getProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyStored();
    }

    public int maxProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyCapacity();
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
    }

    public void loadNBTData(NBTTagCompound aNBT) {
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            // empty if block
        }
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public long[] getStoredEnergy() {
        boolean scaleOverflow = false;
        boolean storedOverflow = false;
        long tScale = this.getBaseMetaTileEntity().getEUCapacity();
        long tStored = this.getBaseMetaTileEntity().getStoredEU();
        long tStep = 0L;
        if (this.mInventory != null) {
            for (ItemStack aStack : this.mInventory) {
                if (!GT_ModHandler.isElectricItem((ItemStack)aStack)) continue;
                if (aStack.func_77973_b() instanceof GT_MetaBase_Item) {
                    Long[] stats = ((GT_MetaBase_Item)aStack.func_77973_b()).getElectricStats(aStack);
                    if (stats == null) continue;
                    if (stats[0] > 0x3FFFFFFFFFFFFFFFL) {
                        scaleOverflow = true;
                    }
                    tScale += stats[0].longValue();
                    tStep = ((GT_MetaBase_Item)aStack.func_77973_b()).getRealCharge(aStack);
                    if (tStep > 0x3FFFFFFFFFFFFFFFL) {
                        storedOverflow = true;
                    }
                    tStored += tStep;
                    continue;
                }
                if (!(aStack.func_77973_b() instanceof IElectricItem)) continue;
                tStored += (long)ElectricItem.manager.getCharge(aStack);
                tScale += (long)((IElectricItem)aStack.func_77973_b()).getMaxCharge(aStack);
            }
        }
        if (scaleOverflow) {
            tScale = Long.MAX_VALUE;
        }
        if (storedOverflow) {
            tStored = Long.MAX_VALUE;
        }
        return new long[]{tStored, tScale};
    }

    public String[] getInfoData() {
        return new String[]{"Tile Type: " + this.getTileEntityBaseType()};
    }

    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public boolean doesExplode() {
        return true;
    }

    public boolean useModularUI() {
        return true;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        this.getBaseMetaTileEntity().add4by4Slots(builder, new IDrawable[0]);
    }
}

