/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.items.behaviours;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Block_Ores;
import gregtech.common.blocks.GT_TileEntity_Ores;
import gregtech.common.items.behaviors.Behaviour_Prospecting;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;

public class Behaviour_Prospecting_Ex
extends Behaviour_Prospecting {
    private final int mVanillaCosts;
    private final int mEUCosts;

    public Behaviour_Prospecting_Ex(int aVanillaCosts, int aEUCosts) {
        super(aVanillaCosts, aEUCosts);
        this.mVanillaCosts = aVanillaCosts;
        this.mEUCosts = aEUCosts;
    }

    public boolean onItemUseFirst(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ) {
        if (aWorld.field_72995_K) {
            return false;
        }
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock == null) {
            return false;
        }
        byte aMeta = (byte)aWorld.func_72805_g(aX, aY, aZ);
        ItemData tAssotiation = GT_OreDictUnificator.getAssociation((ItemStack)new ItemStack(aBlock, 1, (int)aMeta));
        if (tAssotiation != null && tAssotiation.mPrefix.toString().startsWith("ore")) {
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("This is " + tAssotiation.mMaterial.mMaterial.mDefaultLocalName + " Ore."));
            GT_Utility.sendSoundToPlayers((World)aWorld, (SoundResource)SoundResource.RANDOM_ANVIL_USE, (float)1.0f, (float)-1.0f, (int)aX, (int)aY, (int)aZ);
            return true;
        }
        if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150348_b) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, GregTech_API.sBlockGranites) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150424_aL) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150377_bs) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150346_d) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, (Block)Blocks.field_150349_c)) {
            if (GT_ModHandler.damageOrDechargeItem((ItemStack)aStack, (int)this.mVanillaCosts, (int)this.mEUCosts, (EntityLivingBase)aPlayer)) {
                int i;
                GT_Utility.sendSoundToPlayers((World)aWorld, (SoundResource)SoundResource.RANDOM_ANVIL_USE, (float)1.0f, (float)-1.0f, (int)aX, (int)aY, (int)aZ);
                int tX = aX;
                int tY = aY;
                int tZ = aZ;
                int tMetaID = 0;
                int tQuality = (aItem instanceof GT_MetaGenerated_Tool ? ((GT_MetaGenerated_Tool)aItem).getHarvestLevel(aStack, "") : 0) * 3;
                int j = 6 + tQuality;
                for (i = 0; i < j; ++i) {
                    Block tBlock = aWorld.func_147439_a(tX -= side.offsetX, tY -= side.offsetY, tZ -= side.offsetZ);
                    if (tBlock == Blocks.field_150353_l || tBlock == Blocks.field_150356_k) {
                        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"There is Lava behind this Block.");
                        break;
                    }
                    if (tBlock == Blocks.field_150355_j || tBlock == Blocks.field_150358_i || tBlock instanceof IFluidBlock) {
                        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"There is a Liquid behind this Block.");
                        break;
                    }
                    if (tBlock == Blocks.field_150418_aU || !GT_Utility.hasBlockHitBox((World)aWorld, (int)tX, (int)tY, (int)tZ)) {
                        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"There is an Air Pocket behind this Block.");
                        break;
                    }
                    if (tBlock == aBlock) continue;
                    if (i >= 4) break;
                    GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"Material is changing behind this Block.");
                    break;
                }
                Random tRandom = new Random(aX ^ aY ^ aZ ^ side.ordinal());
                int j2 = 9 + 2 * tQuality;
                for (i = 0; i < j2; ++i) {
                    tX = aX - 4 - tQuality + tRandom.nextInt(j2);
                    Block tBlock = aWorld.func_147439_a(tX, tY = aY - 4 - tQuality + tRandom.nextInt(j2), tZ = aZ - 4 - tQuality + tRandom.nextInt(j2));
                    if (tBlock instanceof GT_Block_Ores) {
                        Materials tMaterial;
                        TileEntity tTileEntity = aWorld.func_147438_o(tX, tY, tZ);
                        if (!(tTileEntity instanceof GT_TileEntity_Ores) || (tMaterial = GregTech_API.sGeneratedMaterials[((GT_TileEntity_Ores)tTileEntity).mMetaData % 1000]) == null || tMaterial == Materials._NULL) continue;
                        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Found traces of " + tMaterial.mDefaultLocalName + " Ore."));
                        return true;
                    }
                    tMetaID = aWorld.func_72805_g(tX, tY, tZ);
                    tAssotiation = GT_OreDictUnificator.getAssociation((ItemStack)new ItemStack(tBlock, 1, tMetaID));
                    if (tAssotiation == null || !tAssotiation.mPrefix.toString().startsWith("ore")) continue;
                    GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Found traces of " + tAssotiation.mMaterial.mMaterial.mDefaultLocalName + " Ore."));
                    return true;
                }
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"No Ores found.");
            }
            return true;
        }
        return false;
    }
}

