/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.energy;

import chylex.hee.init.BlockList;
import chylex.hee.mechanics.energy.EnergyChunkData;
import chylex.hee.mechanics.energy.EnergyClusterHealth;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.EnergySavefile;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityEnergyCluster;
import chylex.hee.world.util.Direction;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public final class EnergyClusterData {
    private EnergyClusterHealth healthStatus = EnergyClusterHealth.HEALTHY;
    private float energyLevel;
    private float maxEnergyLevel;
    private byte regenTimer;
    private byte drainTimer;

    public void generate(World world, int blockX, int blockZ) {
        if (world.field_73011_w.field_76574_g == 1) {
            int chunkX = blockX >> 4;
            int chunkZ = blockZ >> 4;
            EnergySavefile file = (EnergySavefile)WorldDataHandler.get(EnergySavefile.class);
            float average = file.getFromChunkCoords(world, chunkX, chunkZ, false).getEnergyLevel();
            for (int a = 0; a < 4; ++a) {
                average += file.getFromChunkCoords(world, chunkX + Direction.offsetX[a] * EnergySavefile.sectionSize, chunkZ + Direction.offsetZ[a] * EnergySavefile.sectionSize, false).getEnergyLevel();
            }
            this.maxEnergyLevel = (0.25f + world.field_73012_v.nextFloat()) * average * 0.2f;
        } else {
            this.maxEnergyLevel = (0.25f + world.field_73012_v.nextFloat()) * 5.0f;
        }
        this.energyLevel = (0.1f + world.field_73012_v.nextFloat() * 0.9f) * this.maxEnergyLevel;
        this.healthStatus = EnergyClusterHealth.spawnWeightedList.getRandomItem(world.field_73012_v);
    }

    public void update(TileEntityEnergyCluster cluster) {
        float regenTimMp;
        World world = cluster.func_145831_w();
        Random rand = world.field_73012_v;
        if (this.energyLevel > 0.1f && this.energyLevel / this.maxEnergyLevel > 0.85f + rand.nextFloat() * 2.5f && rand.nextInt(75) == 0) {
            float leak = this.energyLevel * (0.05f + rand.nextFloat() * rand.nextFloat() * 0.15f);
            this.energyLevel -= leak;
            cluster.synchronize();
            BlockPosM tmpPos = BlockPosM.tmp();
            int placed = 0;
            for (int attempt = 0; attempt < 8 && placed < 4; ++attempt) {
                tmpPos.set(cluster.field_145851_c + rand.nextInt(7) - 3, cluster.field_145848_d + rand.nextInt(7) - 3, cluster.field_145849_e + rand.nextInt(7) - 3);
                if (!tmpPos.isAir(world)) continue;
                tmpPos.setBlock(world, BlockList.corrupted_energy_low, 3 + MathUtil.floor(leak * 4.5f));
                ++placed;
            }
        }
        float f = regenTimMp = this.energyLevel < this.maxEnergyLevel * 0.5f ? 1.0f + (1.0f - this.energyLevel / (this.maxEnergyLevel * 0.5f)) * 2.0f : 1.0f;
        if (this.healthStatus.regenTimer != -1 && (this.regenTimer = (byte)(this.regenTimer + 1)) > Math.min((int)((float)this.healthStatus.regenTimer * regenTimMp), 125)) {
            this.energyLevel += Math.min((0.0095999995f + (float)Math.sqrt(this.maxEnergyLevel) * 0.005f) * this.healthStatus.regenMultiplier, this.maxEnergyLevel - this.energyLevel);
            cluster.synchronize();
            this.regenTimer = 0;
        }
        if (world.field_73011_w.field_76574_g == 1 && rand.nextInt(this.healthStatus.ordinal() + 1) == 0 && (this.drainTimer = (byte)(this.drainTimer + 1)) > 10 + rand.nextInt(70)) {
            this.drainTimer = 0;
            EnergyChunkData environment = ((EnergySavefile)WorldDataHandler.get(EnergySavefile.class)).getFromBlockCoords(world, cluster.field_145851_c, cluster.field_145849_e, true);
            float envLevel = environment.getEnergyLevel();
            if (envLevel > 1.0E-4f && this.maxEnergyLevel < this.energyLevel) {
                float drain = Math.min(this.maxEnergyLevel - this.energyLevel, Math.min(envLevel * 0.1f, this.maxEnergyLevel * 0.2f));
                drain = drain * 0.75f + rand.nextFloat() * 0.25f * drain;
                drain = environment.drainEnergy(drain);
                this.energyLevel += drain;
                cluster.synchronize();
            }
        }
    }

    public EnergyClusterHealth getHealthStatus() {
        return this.healthStatus;
    }

    public float getEnergyLevel() {
        return this.energyLevel;
    }

    public float getMaxEnergyLevel() {
        return this.maxEnergyLevel;
    }

    public void setEnergyLevel(float newLevel) {
        this.energyLevel = newLevel;
    }

    public float addEnergy(float amount) {
        if (this.energyLevel + amount <= this.maxEnergyLevel) {
            this.energyLevel += amount;
            return 0.0f;
        }
        this.energyLevel = this.maxEnergyLevel;
        return amount -= this.maxEnergyLevel - this.energyLevel;
    }

    public float drainEnergy(float amount) {
        if (this.energyLevel >= amount) {
            this.energyLevel -= amount;
            return 0.0f;
        }
        float diff = amount - this.energyLevel;
        this.energyLevel = 0.0f;
        return diff;
    }

    public boolean drainEnergyUnit() {
        return this.drainEnergyUnits(1);
    }

    public boolean drainEnergyUnits(int units) {
        if (this.energyLevel >= 0.12f * (float)units) {
            this.energyLevel -= 0.12f * (float)units;
            this.regenTimer = (byte)-18;
            return true;
        }
        return false;
    }

    public void healCluster() {
        if (this.healthStatus.ordinal() > 0) {
            this.healthStatus = EnergyClusterHealth.values[this.healthStatus.ordinal() - 1];
        }
    }

    public void weakenCluster() {
        if (this.healthStatus.ordinal() < EnergyClusterHealth.values.length) {
            this.healthStatus = EnergyClusterHealth.values[this.healthStatus.ordinal() + 1];
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("status", (byte)this.healthStatus.ordinal());
        nbt.func_74776_a("lvl", this.energyLevel);
        nbt.func_74776_a("max", this.maxEnergyLevel);
        nbt.func_74774_a("regen", this.regenTimer);
        nbt.func_74774_a("drain", this.drainTimer);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        byte status = nbt.func_74771_c("status");
        this.healthStatus = status >= 0 && status < EnergyClusterHealth.values.length ? EnergyClusterHealth.values[status] : EnergyClusterHealth.HEALTHY;
        this.energyLevel = nbt.func_74760_g("lvl");
        this.maxEnergyLevel = nbt.func_74760_g("max");
        this.regenTimer = nbt.func_74771_c("regen");
        this.drainTimer = nbt.func_74771_c("drain");
    }
}

