/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe;

import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import net.minecraft.item.ItemStack;

public class CraftingMaterialLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (werkstoff.hasItemType(OrePrefixes.screw)) {
            int tVoltageMultiplier = werkstoff.getStats().getMeltingPoint() >= 2800 ? 60 : 15;
            GT_Values.RA.addExtruderRecipe(werkstoff.hasItemType(OrePrefixes.gem) ? werkstoff.get(OrePrefixes.gem) : werkstoff.get(OrePrefixes.ingot), ItemList.Shape_Extruder_Bolt.get(0L, new Object[0]), werkstoff.get(OrePrefixes.bolt, 8), (int)Math.max(werkstoff.getStats().getMass() * 2L, 1L), 8 * tVoltageMultiplier);
            GT_Values.RA.addCutterRecipe(werkstoff.get(OrePrefixes.stick), werkstoff.get(OrePrefixes.bolt, 4), null, (int)Math.max(werkstoff.getStats().getMass() * 2L, 1L), 4);
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.bolt), new ItemStack[]{werkstoff.get(OrePrefixes.dustTiny, 1)}, null, 2, 8);
            GT_Values.RA.addLatheRecipe(werkstoff.get(OrePrefixes.bolt), werkstoff.get(OrePrefixes.screw), null, (int)Math.max(werkstoff.getStats().getMass() / 8L, 1L), 4);
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.screw), (long)GT_Proxy.tBits, (Object[])new Object[]{"fX", "X ", Character.valueOf('X'), werkstoff.get(OrePrefixes.bolt)});
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.screw), new ItemStack[]{werkstoff.get(OrePrefixes.dustTiny, 1)}, null, 2, 8);
            if (werkstoff.hasItemType(OrePrefixes.gem)) {
                return;
            }
            GT_Values.RA.addExtruderRecipe(werkstoff.get(OrePrefixes.ingot), ItemList.Shape_Extruder_Ring.get(0L, new Object[0]), werkstoff.get(OrePrefixes.ring, 4), (int)Math.max(werkstoff.getStats().getMass() * 2L, 1L), 6 * tVoltageMultiplier);
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.ring), (long)GT_Proxy.tBits, (Object[])new Object[]{"h ", "fX", Character.valueOf('X'), werkstoff.get(OrePrefixes.stick)});
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.gearGt), (long)GT_Proxy.tBits, (Object[])new Object[]{"SPS", "PwP", "SPS", Character.valueOf('P'), werkstoff.get(OrePrefixes.plate), Character.valueOf('S'), werkstoff.get(OrePrefixes.stick)});
            GT_Values.RA.addExtruderRecipe(werkstoff.get(OrePrefixes.ingot, 4), ItemList.Shape_Extruder_Gear.get(0L, new Object[0]), werkstoff.get(OrePrefixes.gearGt), (int)Math.max(werkstoff.getStats().getMass() * 5L, 1L), 8 * tVoltageMultiplier);
            GT_Values.RA.addExtruderRecipe(werkstoff.get(OrePrefixes.ingot), ItemList.Shape_Extruder_Wire.get(0L, new Object[0]), werkstoff.get(OrePrefixes.wireFine, 8), (int)Math.max((float)werkstoff.getStats().getMass() * 1.5f, 1.0f), 8 * tVoltageMultiplier);
            GT_Values.RA.addWiremillRecipe(werkstoff.get(OrePrefixes.ingot), GT_Utility.getIntegratedCircuit((int)3), werkstoff.get(OrePrefixes.wireFine, 8), (int)Math.max(werkstoff.getStats().getMass(), 1L), 8 * tVoltageMultiplier);
            GT_Values.RA.addWiremillRecipe(werkstoff.get(OrePrefixes.stick), GT_Utility.getIntegratedCircuit((int)3), werkstoff.get(OrePrefixes.wireFine, 4), (int)Math.max((float)werkstoff.getStats().getMass() * 0.5f, 1.0f), 8 * tVoltageMultiplier);
            if (WerkstoffLoader.smallGearShape != null) {
                GT_Values.RA.addExtruderRecipe(werkstoff.get(OrePrefixes.ingot), WerkstoffLoader.smallGearShape.get(0L, new Object[0]), werkstoff.get(OrePrefixes.gearGtSmall), (int)werkstoff.getStats().getMass(), 8 * tVoltageMultiplier);
            }
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.gearGtSmall), (long)GT_Proxy.tBits, (Object[])new Object[]{" S ", "hPx", " S ", Character.valueOf('S'), werkstoff.get(OrePrefixes.stick), Character.valueOf('P'), werkstoff.get(OrePrefixes.plate)});
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.rotor), (long)GT_Proxy.tBits, (Object[])new Object[]{"PhP", "SRf", "PdP", Character.valueOf('P'), werkstoff.get(OrePrefixes.plate), Character.valueOf('R'), werkstoff.get(OrePrefixes.ring), Character.valueOf('S'), werkstoff.get(OrePrefixes.screw)});
            GT_Values.RA.addAssemblerRecipe(werkstoff.get(OrePrefixes.plate, 4), werkstoff.get(OrePrefixes.ring), Materials.Tin.getMolten(32L), werkstoff.get(OrePrefixes.rotor), 240, 24);
            GT_Values.RA.addAssemblerRecipe(werkstoff.get(OrePrefixes.plate, 4), werkstoff.get(OrePrefixes.ring), Materials.Lead.getMolten(48L), werkstoff.get(OrePrefixes.rotor), 240, 24);
            GT_Values.RA.addAssemblerRecipe(werkstoff.get(OrePrefixes.plate, 4), werkstoff.get(OrePrefixes.ring), Materials.SolderingAlloy.getMolten(16L), werkstoff.get(OrePrefixes.rotor), 240, 24);
            if (WerkstoffLoader.rotorShape != null) {
                GT_Values.RA.addExtruderRecipe(werkstoff.get(OrePrefixes.ingot, 5), WerkstoffLoader.rotorShape.get(0L, new Object[0]), werkstoff.get(OrePrefixes.rotor), 200, 60);
            }
            if (werkstoff.hasItemType(OrePrefixes.cellMolten)) {
                // empty if block
            }
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.gearGt), new ItemStack[]{werkstoff.get(OrePrefixes.dust, 4)}, null, 2, 8);
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.gearGtSmall), new ItemStack[]{werkstoff.get(OrePrefixes.dust, 1)}, null, 2, 8);
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.rotor), new ItemStack[]{werkstoff.get(OrePrefixes.dust, 4), werkstoff.get(OrePrefixes.dustSmall)}, null, 2, 8);
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.ring), new ItemStack[]{werkstoff.get(OrePrefixes.dustSmall, 1)}, null, 2, 8);
        }
    }
}

